;##################################################################
;
;   ZMercury (Bullet/Enemy collision)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   Copyright 2004 by Patrick Davidson.  This software may be freely
;   modified and/or copied with no restrictions.  There is no warranty.
;
;   This file was last updated February 18, 2004.
;
;##################################################################     

hit_enemy:
        ld      hl,player_bullets
        ld      b,pb_num
loop_bullet_collide:
        ld      a,(hl)
        or      a
        jr      z,no_bullet_c
        push    bc
        ld      (temp_address),hl

        inc     hl                      ; save bullet to test bed
        ld      de,test_coords
        ld      bc,5
        ldir

        ld      hl,e_array
        ld      b,e_num
loop_enemy_collide:
        ld      a,(hl)
        cp      2
        jr      c,no_enemy_c
        push    bc
        push    hl
        inc     hl
        call    collision_check
        jr      nc,no_eb_collision
        ld      hl,(temp_address)
        ld      (hl),0
        pop     hl
        push    hl
        ld      a,(test_damage)
        call    damage_enemy

no_eb_collision:
        pop     hl
        pop     bc
no_enemy_c:
        ld      de,e_size
        add     hl,de
        djnz    loop_enemy_collide

        ld      hl,(temp_address)
        pop     bc
no_bullet_c:
        ld      de,pb_size
        add     hl,de
        djnz    loop_bullet_collide
        ret
