;##################################################################
;
;   ZMercury - panel display
;
;   Programmed by Patrick Davidson (pad@ocf.berkeley.edu)
;        
;   Copyright 2011 by Patrick Davidson.  This software may be freely
;   modified and/or copied with no restrictions.  There is no warranty.
;
;   This file was last updated June 22, 2011.
;
;##################################################################

#ifndef NARROW
PANEL_BASE      =$ffb0
PANEL_WIDTH     =16
#else
PANEL_BASE      =VISIBLE_SIZE+9
PANEL_WIDTH     =13
#endif

;############## Show information panel in game

panel_msg:
#ifndef NARROW
        .db     "ZMercury!     "
#endif
        .db     "Shield:                  "
        .db     "Score:",0

show_panel:
        ROM_CALL(CLEARLCD)

#ifdef NARROW
        ld      hl,$3a0a
#else
        ld      hl,$3a01
#endif
        ld      (CURSOR_X),hl
        ld      hl,panel_msg
        ROM_CALL(D_ZM_STR)

#ifdef NARROW
        ld      hl,(_GFX_BUFFER)
        call    Read_LCD
#endif

        call    show_score

show_lives:
        ld      de,PANEL_BASE+8
#ifdef NARROW
        ld      hl,(_GFX_BUFFER)
        add     hl,de
        ex      de,hl
#endif
        ld      hl,shield
        ld      b,2
        jp      DISPLAY_BCD

show_score:
        ld      de,PANEL_BASE+$d
#ifdef NARROW
        ld      hl,(_GFX_BUFFER)
        add     hl,de
        ex      de,hl
#endif
        ld      hl,score
        ld      b,3
        jp      DISPLAY_BCD

;############## Add a constant to a packed BCD number
;
; HL -> last digit of destination
; A = value to add
; B = number of bytes
;
; Returns with the C flag 0 if no carry out, 1 if carry out.

ADD_BCD:
        add     a,(hl)
        daa
        ld      (hl),a
loop_bcd:
        ret     nc
        dec     hl
        ld      a,(hl)
        add     a,1
        daa
        ld      (hl),a
        djnz    loop_bcd
        ret

;############## Compares BCD numbers
;
; HL ->number to subtract from other
; DE ->number
; B = number of bytes
;
; Returns with flags indicating comparion results.  Changes A, B, DE, HL.
; Zero set if equal, carry if HL > DE.

CP_BCD: 
cmpl:   ld      a,(de)
        cp      (hl)
        ret     nz
        inc     de
        inc     hl
        djnz    cmpl
        ret

;############## Display hex/BCD numbers at line A, column C (B*2 digits)
;
; A = Y coordinate on screen (0 = top, 63 = bottom)
; C = column on screen of number start (0 = rightmost, counts up to left)
; HL -> location of number in memory
;
; Wide version draws straight to screen, narrow version will use
; _GFX_BUFFER as backup storage (and be slower).

DISPLAY_BCD_XY:

#ifdef NARROW
        push    hl
        push    af              ; first read in the display
        push    bc                      
        ld      hl,(_GFX_BUFFER)       
        call    Read_LCD
        pop     bc
        pop     af

        ld      l,a
        ld      h,0
        add     hl,hl
        push    af
        call    ADD_HL_A        ; HL = Y * 3
        pop     af
        add     hl,hl           ; HL = Y * 6
        add     hl,hl           ; HL = Y * 12
        call    ADD_HL_A        ; HL = Y * 13
        ld      de,(_GFX_BUFFER)
        add     hl,de           ; HL = start address in line   
        ld      a,BUFF_WIDTH-2
        sub     c
        call    ADD_HL_A
        ex      de,hl
        pop     hl
        call    DISPLAY_BCD
        jp      display_screen
#else
        push    hl
        ld      l,a
        ld      h,0
        add     hl,hl
        add     hl,hl
        add     hl,hl           ; HL = Y * 8
        add     hl,hl           ; HL = Y * 16
        ld      de,$fc00
        add     hl,de           ; HL = start address in line   
        ld      a,15
        sub     c
        call    ADD_HL_A
        ex      de,hl
        pop     hl
#endif

;############## Display hex/BCD numbers in special text (B*2 digits)
;
; HL -> location of number in memory
; DE -> graphics buffer address (upper-left corner of number)

DISPLAY_BCD:
        ld      a,(hl)
        push    de
        push    hl
        push    bc
        call    display_a_bcd
        pop     bc
        pop     hl
        pop     de
        inc     de
        inc     hl
        djnz    DISPLAY_BCD
        ret

display_a_bcd:
        push    af                      ; Save character
        and     15                      ; A = low digit
        ld      c,a
        add     a,a
        add     a,a                   
        add     a,c
        ld      c,a
        ld      b,0
        ld      hl,digit_images
        add     hl,bc                   ; HL -> start of image

        ex      de,hl                   ; DE -> char image, HL -> screen
        push    hl                      ; Save screen address
        ld      c,PANEL_WIDTH
        ld      a,5
loop_copy_digit:
        push    af
        ld      a,(de)
        ld      (hl),a
        pop     af
        inc     de
        add     hl,bc
        dec     a
        jr      nz,loop_copy_digit
        pop     de
                                        ; Restore screen address in DE
        pop     af
        rrca
        rrca
        rrca
        rrca
        and     15
        ld      c,a
        add     a,a
        add     a,a                    
        add     a,c
        ld      c,a
        ld      hl,digit_images
        add     hl,bc                   ; HL -> start of image

        ex      de,hl                   ; DE -> char image, HL -> screen
        ld      c,PANEL_WIDTH
        ld      a,5
loop_or_digit:
        push    af
        ld      a,(de)
        add     a,a
        add     a,a
        add     a,a
        add     a,a
        or      (hl)
        ld      (hl),a
        pop     af
        inc     de
        add     hl,bc
        dec     a
        jr      nz,loop_or_digit
        ret
        
digit_images:
        .db     %00000010
        .db     %00000101
        .db     %00000101
        .db     %00000101
        .db     %00000010

        .db     %00000010
        .db     %00000010
        .db     %00000010
        .db     %00000010
        .db     %00000010

        .db     %00000010
        .db     %00000101
        .db     %00000001
        .db     %00000010
        .db     %00000111

        .db     %00000110
        .db     %00000001
        .db     %00000110
        .db     %00000001
        .db     %00000110

        .db     %00000101
        .db     %00000101
        .db     %00000111
        .db     %00000001
        .db     %00000001

        .db     %00000111
        .db     %00000100
        .db     %00000110
        .db     %00000001
        .db     %00000110

        .db     %00000011
        .db     %00000100
        .db     %00000110
        .db     %00000101
        .db     %00000010

        .db     %00000111
        .db     %00000001
        .db     %00000001
        .db     %00000010
        .db     %00000010

        .db     %00000010
        .db     %00000101
        .db     %00000010
        .db     %00000101
        .db     %00000010

        .db     %00000010
        .db     %00000101
        .db     %00000011
        .db     %00000001
        .db     %00000110
