;##################################################################
;
;   ZMercury (generic low-level support routines)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   Copyright 2004 by Patrick Davidson.  This software may be freely
;   modified and/or copied with no restrictions.  There is no warranty.
;
;   This file was last updated September 19, 2004.
;
;##################################################################   

;############## Contrast adjustment

adjust_contrast:
        ld      a,%11111101
        out     (1),a
        ld      hl,contrastkeys
        ld      a,(hl)                  ; load old mask
        cpl                             ; non-pressed keys (last frame) 0
        ld      b,a
        in      a,(1)                   ; pressed now 0
        ld      (hl),a                  ; save current mask
        or      b                       ; 0 = keys just gone down
        bit     2,a
        jr      z,contrast_down
        bit     1,a
        ret     nz

#ifdef NARROW
contrast_up:
        ld      a,(CONTRAST)
        cp      CONTRAST_MAX
        ret     z
        inc     a
        ld      (CONTRAST),a
        add     a,CONTRAST_ADJ
        or      $c0
        out     ($10),a
        ret
contrast_down:
        ld      a,(CONTRAST)
        or      a
        ret     z
        dec     a
        ld      (CONTRAST),a
        add     a,CONTRAST_ADJ
        or      $c0
        out     ($10),a
        ret
#else
contrast_up:
        ld      a,(CONTRAST)
        cp      $1f
        ret     z
        inc     a
        ld      (CONTRAST),a
        out     ($2),a
        xor     a
        ret
contrast_down:
        ld      a,(CONTRAST)
        or      a
        ret     z
        dec     a
        ld      (CONTRAST),a
        out     ($2),a
        xor     a
        ret
#endif

;############## Basic computations

ADD_HL_A:
        add     a,l
        ld      l,a
        ret     nc
        inc     h
        ret     

;############## Wait for the next frame

wait_next_frame:
#ifdef NARROW
        ei
#endif
        ld      hl,timer
        ld      a,(hl)
        ld      (speed),a
loop_wnf:
        ld      a,(hl)
#ifdef NARROW
        cp      4
#else
        cp      7
#endif
        jr      c,loop_wnf
        ld      (hl),0
        ret
