;##################################################################
;
;   ZMercury (Player handling)
;
;   Programmed by Patrick Davidson (pad@ocf.berkeley.edu)
;        
;   Copyright 2011 by Patrick Davidson.  This software may be freely
;   modified and/or copied with no restrictions.  There is no warranty.
;
;   This file was last updated June 22, 2011.
;
;##################################################################     

;############## Movement (by OTH_ARROW) and ship display

move_player:
        call    OTH_ARROW
        ld      c,a

        ld      hl,player_y
        rr      c     
        jr      c,no_down       
        ld      a,(hl)  
        inc     a
        cp      96-12+1
        jr      z,no_down       
        ld      (hl),a  
no_down:
        inc     hl      
        rr      c       
        jr      c,no_left       
        ld      a,(hl)
        dec     a
        cp      MIN_PLAYER_X
        jr      z,no_left       
        ld      (hl),a  
no_left:
        rr      c       
        jr      c,no_right      
        ld      a,(hl)  
        inc     a
        cp      MAX_PLAYER_X    
        jr      z,no_right      
        ld      (hl),a  
no_right:
        ld      d,(hl)  
        dec     hl      
        rr      c       
        jr      c,no_up 
        ld      a,(hl)  
        dec     a
        cp      31      
        jr      z,no_up 
        ld      (hl),a  
no_up:                           

;############## fire testing

        ld      hl,justfired
        rr      c
        rr      c
        push    bc
        jr      nc,pressed_fire
        ld      (hl),0
        jr      shoot_end

pressed_fire:
        ld      a,(hl)
        ld      (hl),1
        or      a
        call    z,player_shoot
shoot_end:
        pop     bc

;############## exit handling

        rr      c
        jr      c,continue_game
player_quit:
        pop     af
        jp      game_over
continue_game:
        rr      c
        jr      c,no_save
        ld      a,1
        ld      (saved_flag),a
        pop     af
        jp      finalexit
no_save:

;############## draw player

        ld      de,(player_y)
        push    de
        ld      hl,img_player
        call    drw_spr

        call    adjust_contrast

;############## check for terrain collisions

        pop     hl
        push    hl
        call    background_collision_check
        pop     hl
        push    hl
        ld      de,11
        add     hl,de
        call    background_collision_check
        pop     hl
        push    hl
        ld      de,7<<8
        add     hl,de
        call    background_collision_check
        pop     hl
        ld      de,(7<<8)+11

;############## do the terrain checking at (H,L)

background_collision_check:
        ex      de,hl
        ld      a,e
        sub     32
#ifdef NARROW
        ld      b,a
        add     a,a
        add     a,b
        ld      l,a
        ld      h,0
        add     hl,hl
        add     hl,hl
#else
        add     a,a
        add     a,a
        ld      l,a
        ld      h,0
        add     hl,hl
        add     hl,hl
#endif
        ld      a,e
        sub     32
        call    ADD_HL_A                ; HL = Y * 17
        ld      bc,(terr_buffer)
        add     hl,bc
        dec     hl
        ld      a,d
#ifdef NARROW
        sub     32
#endif
        rra
        rra
        rra
        and     31
        call    ADD_HL_A                ; HL -> byte in terrain buffer
        ld      b,(hl)                  ; B = byte to check
        ld      a,d
        and     7
        ld      hl,bitmasks
        call    ADD_HL_A
        ld      a,(hl)
        and     b
        ret     nz

;############## Handle collision against player

hit_player:
        ld      hl,shield+1
        ld      b,2
hit_loop:
        ld      a,(hl)
        add     a,$99
        daa
        ld      (hl),a
        ret     c
        dec     hl
        djnz    hit_loop
        ret

bitmasks:
        .db     128,64,32,16,8,4,2,1
