;##################################################################
;
;   ZMercury (title screen)
;                                                                     
;   Programmed by Patrick Davidson (pad@ocf.berkeley.edu)
;        
;   Copyright 2011 by Patrick Davidson.  This software may be freely
;   modified and/or copied with no restrictions.  There is no warranty.
;
;   This file was last updated August 1, 2011.
;
;##################################################################

title_screen:
        ld      hl,title_text
title_screen_hl:
        call    show_text

title_loop:   
        call    scroll_stars
        call    draw_background
        call    wait_next_frame
        call    display_buffer
        call    adjust_contrast
        call    GET_KEY

#ifndef NARROW
        cp      K_EXIT
        jr      z,title_quit
        cp      K_CLEAR
        jr      z,title_quit
        cp      K_SECOND
        jr      z,start_game
        ld      hl,addresses
        cp      K_ALPHA
        jr      z,title_screen_hl
        ld      hl,instructions
        cp      K_MORE
#else
        cp      KEY_CODE_CLEAR
        jr      z,title_quit
        cp      KEY_CODE_SECOND
        jr      z,start_game
        ld      hl,addresses
        cp      KEY_CODE_ALPHA
        jr      z,title_screen_hl
        ld      hl,instructions
        cp      KEY_CODE_DEL
#endif
        jr      z,title_screen_hl
        or      a
        jr      z,title_loop
        jr      title_screen

start_game:
        ld      hl,(terr_buffer)
        ld      (hl),-1
        ld      bc,TERRAIN_SIZE-1
        jp      OTH_FILL

title_quit:
        pop     hl
        ret

show_text:
        push    hl
        ROM_CALL(CLEARLCD)
        pop     hl
        ld      b,6
        ld      de,1

lst:    ld      (CURSOR_ROW),de
        push    de
        push    bc
;        push    hl
        ROM_CALL(D_ZT_STR)
;        pop     hl
;fe:     ld      a,(hl)
;        inc     hl
;        or      a
;        jr      nz,fe
        pop     bc
        pop     de
        inc     e
        djnz    lst

#ifdef NARROW
        ld      hl,(terr_buffer)
        call    Read_LCD
        ld      hl,(terr_buffer)
        ld      bc,TERRAIN_SIZE
invert_loop:
        ld      a,(hl)
        cpl
        ld      (hl),a
        inc     hl
        dec     bc
        ld      a,b
        or      c
        jr      nz,invert_loop
#else
        ld      hl,(terr_buffer)
        ld      de,BUFF_WIDTH*TERRAIN_SKIP
        add     hl,de
        ld      de,$fc00
        ld      b,VISIBLE_HEIGHT
loop_copy_outer:
        push    bc
        ld      b,16
loop_copy_inner:
        ld      a,(de)
        inc     de
        cpl
        ld      (hl),a
        inc     hl
        djnz    loop_copy_inner
        pop     bc
        inc     hl
        djnz    loop_copy_outer
#endif
        ret


#ifdef NARROW
title_text:
        .db     "ZMercury 0.70 by",0
        .db     "Patrick Davidson",0
        .db     0
        .db     "Push 2ND to play",0
        .db     "DEL:Instructions",0
        .db     "ALPHA:Addresses",0
instructions:
        .db     "Arrows move ship",0
        .db     "  MODE to quit",0
        .db     "DEL to save game",0
        .db     "  2ND to shoot",0
        .db     0
        .db     "Push 2ND to play",0
addresses:
        .db     "EMail: pad@ocf.",0
        .db     "    berkeley.edu",0
        .db     "IRC: PatrickD on",0
        .db     "       EfNet #ti",0
        .db     "http://www.ocf.b",0
        .db     "erkeley.edu/~pad",0
#else
title_text:
        .db     "    ZMercury 0.70",0
        .db     " by Patrick Davidson",0
        .db     0
        .db     "  Press 2ND to play",0
        .db     "MORE for instructions",0
        .db     " ALPHA for addresses",0
instructions:
        .db     " Arrow keys move ship",0
        .db     "  Push EXIT to quit",0
        .db     " MORE saves the game",0
        .db     "  Push 2ND to shoot",0
        .db     0
        .db     "  Push 2ND to begin",0
addresses:
        .db     "EMail: pad@ocf.",0
        .db     "         berkeley.edu",0
        .db     "IRC: PatrickD on",0
        .db     "            EfNet #ti",0
        .db     "http://www.ocf.",0
        .db     "   berkeley.edu/~pad/",0

#endif


