;##################################################################
;
;   Z M E R C U R Y        F O R         T I - 8 3         I O N
;
;   Programmed by Patrick Davidson (pad@ocf.berkeley.edu)
;        
;   Copyright 2011 by Patrick Davidson.  This software may be freely
;   modified and/or copied with no restrictions.  There is no warranty.
;
;   This file was last updated August 1, 2011.
;
;##################################################################     

#define TI83
#define NARROW

#include    "ion.inc"

K_EXIT          =$37
K_DEL           =$38
K_ENTER         =9
TEXT_MEM        =saferam3
                           
#define ROM_CALL(this_or_that) bcall(this_or_that)
D_ZT_STR        =_puts
D_HL_DECI       =_disphl
TX_CHARPUT      =_putc
CLEARLCD        =_clrlcdf
CURSOR_ROW      =currow
CURSOR_COL      =curcol
D_ZM_STR        =_vputs
CURSOR_X        =pencol
                            
interrupt_entry =$8282
interrupt_byte  =$82
interrupt_table =$8300
interrupt_reg   =$83

free_memory             =$930d

#include "zmercury.i"
#include "keys.i"

        .org    progstart

        ret
        jr      nc,start

        .db     "ZMercury 0.70",0

start:  res     1,(iy+13)                   ;don't overwrite text memory
        call    start_inner
        set     1,(iy+13)
        ret

start_inner:
        call    _memfree
        ld      de,TERRAIN_SIZE*2
        sbc     hl,de
        jr      nc,no_whining

whine_about_memory:
        ld      hl,0
        ld      (CURSOR_ROW),hl
        ld      hl,whining_message
        bcall(_puts)
        call    GET_KEY
loop_wait_whine:
        call    GET_KEY
        or      a
        jr      z,loop_wait_whine
        ret 
whining_message:
        .db     "ERROR: Need 1664"
        .db     "bytes free RAM",0

no_whining:
        ld      hl,graph_mem
        ld      (star_buffer),hl
        ld      hl,(free_memory)
        ld      (_GFX_BUFFER),hl
        ld      de,TERRAIN_SIZE
        add     hl,de
        ld      (terr_buffer),hl

;############## Include remainder of game files

#include "zmerc.asm"
#include "lib.asm"
#include "gfx.asm"
#include "terrain.asm"
#include "drwspr.asm"
#include "images.asm"
#include "player.asm"
#include "bullets.asm"
#include "vars.asm"
#include "info.asm"
#include "enemies.asm"
#include "entry.asm"
#include "collide.asm"
#include "hitenemy.asm"
#include "ebullets.asm"
#include "eshoot.asm"
#include "scores.asm"
#include "title.asm"
#include "lib12.asm"
#include "non85.asm"
#include "bonus.asm"

        .end
