;##################################################################
;
;   ZMercury for TI-86
;
;   Programmed by Patrick Davidson (pad@ocf.berkeley.edu)
;        
;   Copyright 2011 by Patrick Davidson.  This software may be freely
;   modified and/or copied with no restrictions.  There is no warranty.
;
;   This file was last updated August 1, 2011.
;
;##################################################################

;############## Definitions of system calls

#define ROM_CALL(addr) call addr

DO_LD_HL_MHL    =$4010                  ; _ldHLind
UNPACK_HL       =$4044                  ; _divHLby10
_flushAllMenus  =$49DC
TX_CHARPUT      =$4A2B                  ; _putc                
D_ZT_STR        =$4A37                  ; _puts                 
CLEARLCD        =$4A7E                  ; _clrLCD
_vputs          =$4AA5                          
_runindicoff    =$4AB1              

;############## Definitions of memory areas

GFX_BUFFER      =$8642
CONTRAST        =$C008
CURSOR_ROW      =$C00F                  ; _curRow
CURSOR_COL      =$C010                  ; _curCol
TEXT_MEM        =$C0F9                  ; _textShadow
CURSOR_X        =$C37C                  ; _penCol
                                        
_asm_exec_ram   =$D748

;############## Definitions of GET_KEY values

K_MORE          =$38
K_EXIT          =$37
K_SECOND        =$36
K_F1            =$35
K_F2            =$34
K_F3            =$33
K_F4            =$32
K_F5            =$31
K_ALPHA         =$30
K_DEL           =$20
K_3             =$12
K_CLEAR         =$0F
K_MINUS         =$0B
K_PLUS          =$0A
K_ENTER         =$09
K_UP            =$04
K_DOWN          =$01

;############## Good stuff

#define __TI86__
#include "zmercury.i"

;############## TI-86 program header (for YAS, etc.)

        .org    _asm_exec_ram
        nop
        jp      startup
        .dw     0
        .dw     title
#include "vars.asm"
title:  .db     "ZMercury 0.70 by Patrick D",0

;############## Initialization / exit

startup:
        call    _flushAllMenus
        call    _runindicoff

        ld      (iy+13),0               ; no text scroll or shadow write

#define CONTIGUOUS_BUFFERS
        ld      hl,$9000
        ld      (star_buffer),hl
        ld      hl,$9000+VISIBLE_SIZE
        ld      (terr_buffer),hl
        ld      hl,GFX_BUFFER
        ld      (_GFX_BUFFER),hl
        call    main

        ld      hl,variable_name
        call    $42d7                   ;_MOV10TOOP1
        call    $46CB                   ; _FINDSYM; BDE -> start of program
        ld      hl,perm_vars+4-_asm_exec_ram
        ld      a,b
        add     hl,de
        adc     a,0                     ; AHL -> perm storage in variable
        call    $5285                   ; _SET_ABS_DEST_ADDR
        ld      a,0
        ld      hl,perm_vars
        call    $4647                   ; _SET_ABS_SRC_ADDR
        ld      a,0
        ld      hl,perm_vars_end-perm_vars
        call    $464f                   ; _SET_MM_NUM_BYTES
        call    $52ed                   ; _mm_ldir

        ld      hl,TEXT_MEM
        ld      (hl),' '               
        ld      bc,167
        ld      de,TEXT_MEM+1
        ldir
        call    CLEARLCD
        ld      hl,0
        ld      ($C00F),hl              ;CURSOR_ROW
        ld      (iy+13),6
        set     0,(iy+3)
        ret

variable_name:
        .db     0,8,"zmercury"

;############## Interrupt handler

interrupt_code:
        push    af
        call    $1234                   ; Actual address written over this

        in      a,(3)                   ; Bit 1 = ON key status
        and     1
        add     a,9                     ; A = 10 if ON pressed, 9 if not
        out     (3),a                  
        ld      a,11
        out     (3),a                   
        ei
        pop     af
        reti
interrupt_code_end:

INT_INSTALL:
        ld      (interrupt_code+2),hl
        ld      hl,$CA00
        ld      (hl),$CB
        ld      bc,256
        call    OTH_FILL
        ld      hl,interrupt_code
        ld      de,$CBCB
        ld      bc,interrupt_code_end-interrupt_code
        ldir
        ld      a,$CA
        ld      i,a
        im      2
        ret

INT_REMOVE:
        im      1
        ret

;############## Custom-font-safe display routines

D_ZM_STR:
        di
        call    _vputs
        ei
        ret

;############## Include remainder of game files
        
#include "zmerc.asm"
#include "lib.asm"
#include "gfx.asm"
#include "terrain.asm"
#include "drwspr.asm"
#include "images.asm"
#include "player.asm"
#include "bullets.asm"
#include "info.asm"
#include "enemies.asm"
#include "entry.asm"
#include "collide.asm"
#include "hitenemy.asm"
#include "ebullets.asm"
#include "eshoot.asm"
#include "scores.asm"
#include "title.asm"
#include "non85.asm"
#include "bonus.asm"

        .end
