;##################################################################
;
;   ZMercury ("sprite" drawing routine)
;
;   Programmed by Patrick Davidson (pad@ocf.berkeley.edu)
;        
;   Copyright 2004 by Patrick Davidson.  This software may be freely
;   modified and/or copied with no restrictions.  There is no warranty.
;
;   This file was last updated November 27, 2004.
;
;##################################################################     

skip:   ld      a,0
        add     a,e
        ld      e,a
        ret     nc
        inc     d
        ret

clip_top:
        pop     hl              ; HL -> image data
        add     a,(hl)          ; A = bottom Y coordinate + 1
        dec     a
        ret     m
        inc     a               ; A = number of lines on screen
        ld      b,a             ; B = number of lines to draw
        sub     (hl)
        neg                     ; A = number of lines skipped
        ld      (skip+1),a
        inc     a               ; A = number of bytes to skip
        
        add     a,l
        jr      nc,ctad
        inc     h
ctad:   ld      l,a             ; HL -> start of image data to use

        ld      a,d             ; A = X coordinate
        
        ex      de,hl           ; DE -> start of image data to use

        ld      hl,(_GFX_BUFFER)
        dec     hl
        and     %11111000
        rrca
        rrca
        rrca
        add     a,l
        ld      l,a             ; HL -> screen address
        jr      nc,drw_spr_main
        inc     h
        jr      drw_spr_main
        
drw_spr:
        xor     a
        ld      (skip+1),a
        ld      a,d                     ; A = X coordinate
        cp      136
        ret     nc

#ifdef NARROW
        sub     32
        ret     c
        ld      d,a
#endif

        and     7
        ld      b,a
        add     a,a
        add     a,b
        ld      (jumpintable+1),a       ; Save selected shift amount 
        
        push    hl                      ; Save sprite image pointer

        ld      hl,(_GFX_BUFFER)         ; HL -> start of buffer
        dec     hl
        ld      a,e

        sub     MIN_Y
        jr      c,clip_top

        ld      (smc_start_y_coord+1),a

        push    af
        srl     d
        srl     d
        srl     d
        add     a,d
        call    ADD_HL_A                ; HL = buffer + Y + X / 8
        pop     af

#ifndef NARROW
        ld      b,0
        add     a,a                     ; A = Y * 2
        add     a,a
        rl      b                       ; BA = Y * 4
        add     a,a                    
        rl      b                       ; BA = Y * 8
        add     a,a
        rl      b                       ; BA = Y * 16
        ld      c,a
        add     hl,bc                   ; HL = Screen address
#else
        ld      b,a
        add     a,a                     ; A = Y * 2
        add     a,b                     ; A = Y * 3
        add     a,a
        ld      b,0
        rl      b                       ; BA = Y * 6
        add     a,a                    
        rl      b                       ; BA = Y * 12
        ld      c,a
        add     hl,bc                   ; HL = Screen address
#endif
        ex      de,hl                   ; DE = Screen address

        pop     hl
        ld      b,(hl)                  ; B = height
        inc     hl                      ; HL -> image

        ex      de,hl                   ; HL -> screen, DE -> image

smc_start_y_coord:
        ld      a,0                     ; Self-modification stores Y here
        cp      MAX_Y-MIN_Y
        ret     nc
        add     a,b                     ; A = maximum Y coordinate
        cp      MAX_Y-MIN_Y
        jr      c,drw_spr_main
        sub     b                       ; A = Y coordinate
        sub     MAX_Y-MIN_Y             ; A = start Y - bottom
        neg                             ; A = allowable height
        sub     b                       ; A = allowable height - total
        neg                             ; A = amount to skip
        ld      (skip+1),a
        neg
        add     a,b
        ld      b,a
                
drw_spr_main:   
        ld      c,0
        and     a
        
jumpintable:
        jr      table

table:
        jp      routine0
        jp      routine1
        jp      routine2

        jp      routine3
        jp      routine4
        jp      routine5
        jp      routine6

routine7:
        inc     hl
        push    hl
        push    bc
routine7m:
        ld      a,(de)          ;7
        inc     de              ;6

        add     a,a             ;4
        rl      c               ;8
        or     (hl)            ;7
        ld      (hl),a          ;7
        dec     hl              ;6
        ld      a,(hl)          ;7
        or     c               ;4
        ld      (hl),a          ;7

        ld      a,b             ;4
        ld      bc,BUFF_WIDTH+1 ;10
        add     hl,bc           ;11
        ld      c,b             ;4
        ld      b,a             ;4
        djnz    routine7m
        pop     bc
        pop     hl
        call    skip
routine7l:
        ld      a,(de)          ;7
        inc     de              ;6

        add     a,a             ;4
        rl      c               ;8
        xor     (hl)            ;7
        ld      (hl),a          ;7
        dec     hl              ;6
        ld      a,(hl)          ;7
        xor     c               ;4
        ld      (hl),a          ;7

        ld      a,b             ;4
        ld      bc,BUFF_WIDTH+1 ;10
        add     hl,bc           ;11
        ld      c,b             ;4
        ld      b,a             ;4
        djnz    routine7l
        ret

routine0:
        ld      c,BUFF_WIDTH    ;7
        push    hl
        push    bc
routine0m:
        ld      a,(de)          ;7
        inc     de              ;6

        or      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,c             ;4
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,done0m       ;10
        inc     h               ;4
done0m:
        djnz    routine0m
        pop     bc
        pop     hl
        call    skip
routine0l:
        ld      a,(de)          ;7
        inc     de              ;6

        xor     (hl)            ;7
        ld      (hl),a          ;7

        ld      a,c             ;4
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,done0        ;10
        inc     h               ;4
done0:
        djnz    routine0l
        ret

routine1:
        push    hl
        push    bc
routine1m:
        ld      a,(de)          ;7
        inc     de              ;6

        rra                     ;4
        rr      c               ;8
        or      (hl)            ;7
        ld      (hl),a          ;7
        inc     hl              ;6
        ld      a,(hl)          ;7
        or      c               ;4
        ld      (hl),a          ;7

        ld      a,b             ;4
        ld      bc,BUFF_WIDTH-1 ;10
        add     hl,bc           ;11
        ld      c,b             ;4
        ld      b,a             ;4
        djnz    routine1m
        pop     bc
        pop     hl
        call    skip
routine1l:
        ld      a,(de)          ;7
        inc     de              ;6

        rra                     ;4
        rr      c               ;8
        xor      (hl)            ;7
        ld      (hl),a          ;7
        inc     hl              ;6
        ld      a,(hl)          ;7
        xor      c               ;4
        ld      (hl),a          ;7

        ld      a,b             ;4
        ld      bc,BUFF_WIDTH-1 ;10
        add     hl,bc           ;11
        ld      c,b             ;4
        ld      b,a             ;4
        djnz    routine1l
        ret

routine2:
        push    bc
        push    hl
routine2m:
        ld      a,(de)          ;7
        inc     de              ;6

        rrca                    ;4
        rrca                    ;4
        ld      c,a             ;4
        and     $3F             ;7
        or      (hl)            ;7
        ld      (hl),a          ;7
        ld      a,c             ;4
        and     $C0             ;7
        inc     hl              ;6
        or      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,BUFF_WIDTH-1  ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,done2m       ;10
        inc     h               ;4
done2m:
        djnz    routine2m
        pop     hl
        pop     bc
        call    skip
routine2l:
        ld      a,(de)          ;7
        inc     de              ;6

        rrca                    ;4
        rrca                    ;4
        ld      c,a             ;4
        and     $3F             ;7
        xor      (hl)            ;7
        ld      (hl),a          ;7
        ld      a,c             ;4
        and     $C0             ;7
        inc     hl              ;6
        xor      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,BUFF_WIDTH-1  ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,done2       ;10
        inc     h               ;4
done2:
        djnz    routine2l
        ret

routine3:
        push    hl
        push    bc
routine3m:
        ld      a,(de)          ;7
        inc     de              ;6

        rrca                    ;4
        rrca                    ;4
        rrca                    ;4
        ld      c,a             ;4
        and     $1F             ;7
        or      (hl)            ;7
        ld      (hl),a          ;7
        ld      a,c             ;4
        and     $E0             ;7
        inc     hl              ;6
        or      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,BUFF_WIDTH-1  ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,done3m       ;10
        inc     h               ;4
done3m:
        djnz    routine3m
        pop     bc
        pop     hl
        call    skip
routine3l:
        ld      a,(de)          ;7
        inc     de              ;6

        rrca                    ;4
        rrca                    ;4
        rrca                    ;4
        ld      c,a             ;4
        and     $1F             ;7
        xor     (hl)            ;7
        ld      (hl),a          ;7
        ld      a,c             ;4
        and     $E0             ;7
        inc     hl              ;6
        xor     (hl)            ;7
        ld      (hl),a          ;7

        ld      a,BUFF_WIDTH-1  ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,done3        ;10
        inc     h               ;4
done3:
        djnz    routine3l
        ret

routine4:
        push    bc
        push    hl
routine4m:
        ld      a,(de)          ;7
        inc     de              ;6

        rrca                    ;4
        rrca                    ;4
        rrca                    ;4
        rrca                    ;4
        ld      c,a             ;4
        and     $0F             ;7
        or      (hl)            ;7
        ld      (hl),a          ;7
        ld      a,c             ;4
        and     $F0             ;7
        inc     hl              ;6
        or      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,BUFF_WIDTH-1  ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,done4m        ;10
        inc     h               ;4
done4m:
        djnz    routine4m       ;13
        pop     hl
        pop     bc
        call    skip
routine4l:               
        ld      a,(de)          ;7
        inc     de              ;6

        rrca                    ;4
        rrca                    ;4
        rrca                    ;4
        rrca                    ;4
        ld      c,a             ;4
        and     $0F             ;7
        xor      (hl)            ;7
        ld      (hl),a          ;7
        ld      a,c             ;4
        and     $F0             ;7
        inc     hl              ;6
        xor      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,BUFF_WIDTH-1  ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,done4        ;10
        inc     h               ;4
done4:
        djnz    routine4l       ;13
        ret

routine6:
        push    bc
        push    hl
routine6m:
        ld      a,(de)          ;7
        inc     de              ;6

        rlca                    ;4
        rlca                    ;4
        ld      c,a             ;4
        and     $03             ;7
        or      (hl)            ;7
        ld      (hl),a          ;7
        ld      a,c             ;4
        and     $FC             ;7
        inc     hl              ;6
        or      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,BUFF_WIDTH-1  ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,done6m        ;10
        inc     h               ;4
done6m:
        djnz    routine6m        ;13
        pop     hl
        pop     bc
        call    skip
routine6l:
        ld      a,(de)          ;7
        inc     de              ;6

        rlca                    ;4
        rlca                    ;4
        ld      c,a             ;4
        and     $03             ;7
        xor      (hl)            ;7
        ld      (hl),a          ;7
        ld      a,c             ;4
        and     $FC             ;7
        inc     hl              ;6
        xor      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,BUFF_WIDTH-1  ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,done6        ;10
        inc     h               ;4
done6:
        djnz    routine6l        ;13
        ret

routine5:                               
        push    bc
        push    hl
routine5m:
        ld      a,(de)          ;7
        inc     de              ;6

        rlca                    ;4
        rlca                    ;4
        rlca                    ;4
        ld      c,a             ;4
        and     $07             ;7
        or      (hl)            ;7
        ld      (hl),a          ;7
        ld      a,c             ;4
        and     $F8             ;7
        inc     hl              ;6
        or      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,BUFF_WIDTH-1  ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,done5m        ;10
        inc     h               ;4
done5m:
        djnz    routine5m        ;13
        pop     hl
        pop     bc
        call    skip
routine5l:
        ld      a,(de)          ;7
        inc     de              ;6

        rlca                    ;4
        rlca                    ;4
        rlca                    ;4
        ld      c,a             ;4
        and     $07             ;7
        xor      (hl)            ;7
        ld      (hl),a          ;7
        ld      a,c             ;4
        and     $F8             ;7
        inc     hl              ;6
        xor      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,BUFF_WIDTH-1  ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,done5        ;10
        inc     h               ;4
done5:
        djnz    routine5l        ;13
        ret
