;##################################################################
;
;   ZMercury (Enemy bullete)
;
;   Programmed by Patrick Davidson (pad@ocf.berkeley.edu)
;        
;   Copyright 2011 by Patrick Davidson.  This software may be freely
;   modified and/or copied with no restrictions.  There is no warranty.
;
;   This file was last updated August 1, 2011.
;
;##################################################################     

;############## Enemy bullet handling
;
; Iterates through the array of enemy bullets (and bonus drops).

process_enemy_bullets:
        ld      hl,enemy_bullets
        ld      b,eb_num
loop_enemy_bullets:
        ld      a,(hl)                  ; test if enemy bullet exists
        or      a
        jr      z,no_enemy_bullet
        push    bc

        push    hl
        ld      b,a
        and     15                      ; X-movement
        inc     hl
        sub     (hl)
        jr      nc,ebk
        neg
        ld      (hl),a
        ld      d,a

        ld      a,b                     ; Y-movement
        inc     hl
        inc     hl
        sra     a
        sra     a
        sra     a
        sra     a
        add     a,(hl)
        ld      (hl),a
        ld      e,a

        cp      MIN_Y-10
        jr      c,ebk
        cp      MAX_Y
        jr      nc,ebk

        inc     hl                      ; draw sprite
        inc     hl
        inc     hl
        call    DO_LD_HL_MHL
        call    drw_spr
        pop     hl                     

        push    hl                      ; check enemy/player collision
        inc     hl
        call    collision_check
        pop     hl
        jr      nc,enemy_bullet_done

        push    hl
        ld      (hl),0
        ld      de,eb_dmg
        add     hl,de
        ld      b,(hl)                  ; B = amount of damage
        bit     7,b                     ; if negative, it is a bonus
        jr      nz,got_bonus
loop_damage_you:
        push    bc
        call    hit_player
        pop     bc
        djnz    loop_damage_you
no_f_collision:
        pop     hl

enemy_bullet_done:
        pop     bc
no_enemy_bullet
        ld      de,eb_size
        add     hl,de
        djnz    loop_enemy_bullets
        ret

ebk:    pop     hl
        ld      (hl),0
        jr      enemy_bullet_done

got_bonus:
        inc     b
        jr      z,got_health
        inc     b
        jr      z,got_score
        inc     b
        jr      z,got_weapon
        inc     b
        jr      z,got_weapon_curve
        
got_auto_fire:

got_weapon_curve:
        ld      a,2
        jr      got_weapon_a

got_weapon:
        ld      a,1
got_weapon_a:                       ; set weapon type to A, then 25 points
        ld      (weapon_upgrade),a     
        ld      a,51
        ld      (bonus_count),a
add_score_25:                       ; add 25 to score, then back to EB loop
        ld      a,$25
add_score_a:                        ; add 25 to score, then back to EB loop
        ld      hl,score+2
        ld      b,2
        call    ADD_BCD
        jr      no_f_collision

got_health:
        ld      hl,shield+1
        ld      b,1
        ld      a,5
        call    ADD_BCD
        jr      add_score_25
          
got_score:
        ld      a,$75
        jr      add_score_a


