;##################################################################
;
;   ZMercury (Enemies)
;
;   Programmed by Patrick Davidson (pad@ocf.berkeley.edu)
;        
;   Copyright 2011 by Patrick Davidson.  This software may be freely
;   modified and/or copied with no restrictions.  There is no warranty.
;
;   This file was last updated August 1, 2011.
;
;##################################################################     

;############## Enemy handling
;
; Iterates through the array of enemies, processing each one.
             
process_enemies:
        xor     a
        ld      (enemies_left),a
        ld      hl,test_coords          ; prepare for player collision check
        ld      de,(player_y)
        ld      (hl),d
        inc     hl
        ld      (hl),8
        inc     hl
        ld      (hl),e
        inc     hl
        ld      (hl),12

        ld      hl,e_array
        ld      b,e_num
loop_enemies:
        xor     a
        ld      (smc_bonus+1),a

        ld      a,(hl)                  ; test if enemy exists
        or      a
        jr      z,no_enemy
        push    bc

        push    hl                      ; do movement/firing code
        call    process_enemy
        ld      hl,enemies_left
        inc     (hl)
        pop     hl

        push    hl                      ; draw enemy sprite
        inc     hl
        ld      d,(hl)
        inc     hl
        inc     hl
        ld      e,(hl)
        inc     hl
        inc     hl
        inc     hl
        call    DO_LD_HL_MHL
        call    drw_spr
        pop     hl

        ld      a,(hl)
        dec     a
        jr      z,enemy_done
        push    hl                      ; check enemy/player collision
        inc     hl
        call    collision_check
        jr      nc,no_ep_collision
        call    hit_player
        pop     hl

        push    hl
        ld      a,1
        call    damage_enemy

no_ep_collision:
        pop     hl

enemy_done:
smc_bonus:
        ld      a,0
        or      a
        jr      z,no_bonus
        push    hl
        call    deploy_bonus
        pop     hl
no_bonus:
        pop     bc
no_enemy:
        ld      de,e_size
        add     hl,de
        djnz    loop_enemies
        ret

;############## Do A points of damage to enemy at (HL)

damage_enemy:
        push    hl
        ld      de,e_dmg
        add     hl,de
        neg
        add     a,(hl)
        ld      (hl),a
        pop     hl
        ret     c
        push    hl
        ld      (hl),1
        ld      de,e_image
        add     hl,de
        ld      (hl),x1&255
        inc     hl
        ld      (hl),x1>>8

        ld      a,1
        ld      hl,score+2
        ld      b,2
        call    ADD_BCD
        pop     hl

        ret

;############## Dispatch to enemy_specific code by jump table

process_enemy:
        ld      (enemy_smc+1),a
enemy_smc:
        jr      enemy_smc

null_enemy:
        ret
        jp      enemy_exploding
        jp      enemy_4                 ;4
        jp      enemy_7                 ;7
        jp      spinning_sine           ;10
        jp      base_enemy              ;13
        jp      spinning_t              ;16
        jp      boss                    ;19
        
;############## Spinning sine enemy (types 10 and 22)
 
spinning_sine_tough:
        ld      bc,img_spin1b
        jr      spinning_sine_common
        
spinning_sine:
        ld      bc,img_spin1
spinning_sine_common:
        push    hl
        call    animate_enemy

        ld      a,(hl)                  ; count down to 0 (keep value in A)
        or      a
        jr      z,ss_approach_done
        dec     (hl)
ss_approach_done:
        inc     hl
        inc     (hl)
        ld      b,(hl)                  ; B = angle in sine table
        pop     hl

        inc     hl
        or      a
        jr      z,ss_no_left
        dec     (hl)
ss_no_left:

        inc     hl
        inc     hl
        ld      a,b
        and     127
        push    hl
        ld      hl,sine_table
        call    ADD_HL_A
        ld      a,(hl)
spin_y_calculated:
        pop     hl
        ld      (hl),a          

        dec     hl
        dec     hl
        ld      a,(game_timer)
        add     a,l
        and     63
        ret     nz
        ld      de,img_ebullet1
        ld      b,2
        call    enemy_fire_normal
        ret     nz
        jp      enemy_bullet_aim

;############## Spinning T enemy (type 13)

spinning_t:
        push    hl
        ld      bc,img_spint1
        call    animate_enemy

        inc     hl
        inc     (hl)
        inc     (hl)
        inc     (hl)
        ld      b,(hl)                  ; B = angle in sine table
        pop     hl

        inc     hl
        dec     (hl)
        jr      z,erase_enemy_2
        inc     hl
        inc     hl
        ld      a,b
        and     127
        push    hl
        ld      hl,sine_table
        call    ADD_HL_A
        ld      a,(hl)
        srl     a
        add     a,30
        jr      spin_y_calculated

;############## Base enemy

base_enemy:
        inc     hl
        dec     (hl)
        jp      z,erase_enemy_2
        ld      a,(game_timer)
        add     a,l
        and     31
        ret     nz
        ld      de,img_ebullet1
        ld      b,2
        call    enemy_fire_normal
        ret     nz
        jp      enemy_bullet_aim

;############## Exploding enemy (type 1)

enemy_exploding:
        ld      de,e_dmg
        add     hl,de
        ld      (hl),127                ; back to full strength
        ld      a,(game_timer)
        rra
        ret     c
        inc     hl
        ld      e,(hl)
        inc     hl
        ld      d,(hl)
        ex      de,hl                   ; DE -> e_image, HL = sprite
        ld      bc,17
        add     hl,bc                   ; HL -> next sprite
        ld      a,(hl)
        ex      de,hl
        ld      (hl),d
        dec     hl
        ld      (hl),e
        or      a
        ret     nz                      ; return if not at end
        ld      a,$50
        ld      hl,score+2
        ld      b,2
        call    ADD_BCD

        ld      a,(terrain_count)       ; return 7/8 of the time
        and     6
        jr      nz,erase_enemy_2
        inc     a
        ld      (smc_bonus+1),a
        jr      erase_enemy_2  

;############## Simple enemy (type 4)

enemy_4:
        call    left_onepointfive
        ld      a,(game_timer)
        add     a,l
        and     63
        ld      de,img_ebullet1
        ld      b,2
        jp      z,enemy_fire_normal
        ret

left_onepointfive:
        inc     hl
        dec     (hl)
        jr      z,erase_enemy
        ld      a,(game_timer)
        rra
        ret     nc
        dec     (hl)
        ret     nz
erase_enemy:
        pop     hl
erase_enemy_2:
        pop     hl
        pop     hl
        ld      (hl),0
        jp      enemy_done

;############## Phoenix enemy (type 7)

enemy_7:
        call    left_onepointfive
        ld      a,(game_timer)
        add     a,l
        and     63
        ret     nz
        ld      de,img_ebullet2
        ld      b,4
        call    enemy_fire_normal
        ret     nz
        jp      enemy_bullet_aim
        
;############## Boss

boss:   inc     hl
        ld      a,128
        cp      (hl)
        jr      z,x_arrived
        dec     (hl)
x_arrived:
        inc     hl
        inc     hl
        ld      a,(game_timer)
        bit     5,a
        jr      z,no_reverse
        cpl
no_reverse:
        and     31
        add     a,40
        ld      (hl),a

        ld      de,e_counter-e_y
        add     hl,de
        inc     (hl)
        ret     nz
        ld      (hl),-44

        ld      de,e_x-e_counter
        add     hl,de

        ld      b,1
        ld      de,img_ebullet2
        push    hl
        call    enemy_fire_normal
        pop     hl

        ld      b,13
        ld      de,img_ebullet2
        jp      enemy_fire_normal

;############## Animate enemy through image sequence
;
; Input - HL points to beginning of enemy structure
;         BC points to first image in sequence (for restart)
;
; Output - HL points to structures e_counter
;          DE is destroyed

animate_enemy:
        ld      de,e_image              
        add     hl,de                   ; HL -> e_image
        push    hl
        call    DO_LD_HL_MHL            ; HL -> enemy sprite
        ld      de,17
        add     hl,de                   ; DE -> next sprite
        ld      a,(hl)
        or      a
        jr      nz,no_animate_end

        pop     hl
        ld      (hl),c
        inc     hl
        ld      (hl),b
        inc     hl
        ret

no_animate_end:
        ex      de,hl                   ; DE -> new image
        pop     hl
        ld      (hl),e                  ; store new image in e_image
        inc     hl
        ld      (hl),d
        inc     hl
        ret

sine_table:
#include "sines.i"
