;##################################################################
;
;   ZMercury (graphics routines)
;                                                                     
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   Copyright 2005 by Patrick Davidson.  This software may be freely
;   modified and/or copied with no restrictions.  There is no warranty.
;
;   This file was last updated August 13, 2005.
;
;##################################################################     

initialize_display_buffers:
#ifdef CONTIGUOUS_BUFFERS
        ld      hl,(star_buffer)
        ld      (hl),-1
        ld      bc,VISIBLE_SIZE+TERRAIN_SIZE-1
        call    OTH_FILL
#else
        ld      hl,(star_buffer)
        ld      (hl),-1
        ld      bc,VISIBLE_SIZE-1
        call    OTH_FILL

        ld      hl,(terr_buffer)
        ld      (hl),-1
        ld      bc,TERRAIN_SIZE-1
        call    OTH_FILL
#endif

#ifdef NARROW
        ld      hl,(_GFX_BUFFER)
        ld      (hl),0
        ld      bc,TERRAIN_SIZE-1
        call    OTH_FILL
#endif

        ld      b,35
        ld      hl,scroll_terrain
put_star_loop:
        ld      a,(hl)
        push    hl
        and     3
        ld      hl,star_list
        call    ADD_HL_A
        ld      c,(hl)
        pop     hl
        ld      a,(hl)
        inc     hl
        rra
        rra
        and     3
#ifdef NARROW
        cp      3
        jr      z,star_loop_end
#endif
        ld      d,a
        ld      e,(hl)
        inc     hl
        push    hl
        ld      hl,(star_buffer)
        add     hl,de
        ld      (hl),c
        pop     hl
star_loop_end:
        djnz    put_star_loop
        ret

star_list:
        .db     %00111111,%11001111,%11110011,%11111100

;############## SCROLLING

scroll_stars:                           ; scroll star buffer (check timer)
        ld      a,(terrain_count)
        bit     0,a
        ret     z
        ld      hl,(star_buffer)
        ld      de,VISIBLE_SIZE
        add     hl,de
        ld      b,VISIBLE_HEIGHT
        call    scroll_buffer
        ret     c
        ld      hl,(star_buffer)
        ld      de,VISIBLE_SIZE-1
        add     hl,de
        res     0,(hl)
        ret

scroll_buffer:                          ; scroll B lines (hl) right 1
        scf
loop_scroll:
        dec     hl
        rl      (hl)
        dec     hl
        rl      (hl)
        dec     hl
        rl      (hl)
        dec     hl
        rl      (hl)
        dec     hl
        rl      (hl)
        dec     hl
        rl      (hl)
        dec     hl
        rl      (hl)
        dec     hl
        rl      (hl)
        dec     hl
        rl      (hl)
        dec     hl
        rl      (hl)
        dec     hl
        rl      (hl)
        dec     hl
        rl      (hl)
        dec     hl
        rl      (hl)
#ifndef NARROW
        dec     hl
        rl      (hl)
        dec     hl
        rl      (hl)
        dec     hl
        rl      (hl)
        dec     hl
        rl      (hl)
#endif
        djnz    loop_scroll
        ret

;############## COMBINE BACKGROUNDS INTO GFX_BUFFER

#define PROCESS_BYTE ld a,(de) \ inc de \ and (hl) \ inc hl \ ld (bc), a \ inc bc

draw_background:
        ld      de,(star_buffer)
        ld      hl,TERRAIN_SKIP*BUFF_WIDTH
        ld      bc,(terr_buffer)
        add     hl,bc                           ; HL -> visible terrain
        ld      bc,(_GFX_BUFFER)
loop_draw_background:
        PROCESS_BYTE
        PROCESS_BYTE
        PROCESS_BYTE
        PROCESS_BYTE
        PROCESS_BYTE
        PROCESS_BYTE
        PROCESS_BYTE
        PROCESS_BYTE
#ifdef NARROW
        ld      a,(_GFX_BUFFER)
        cp      c
        jr      nz,loop_draw_background
        ld      a,(_GFX_BUFFER+1)
        add     a,3
        cp      b
        jr      nz,loop_draw_background
#else
        ld      a,$22
        cp      c
        jr      nz,loop_draw_background
        ld      a,$8a
        cp      b
        jr      nz,loop_draw_background
#endif

        ret

;############## Display entire screen from buffer

#define DWAIT in a,($10) \ and %10010000 \ jr nz, $-4

display_buffer:

#ifndef NARROW

        ld      de,$FC00
        ld      hl,(_GFX_BUFFER)
        ld      a,VISIBLE_HEIGHT/2
loop_display_buffer:
        ld      bc,16
        ldir
        inc     hl
        ld      bc,16
        ldir
        inc     hl
        dec     a
        jr      nz,loop_display_buffer
        ret

#else

display_screen:
        ld      hl,(_GFX_BUFFER)
        ld      c,$20
        DWAIT
        ld      a,$80
        out     ($10),a
dispColumn:
        DWAIT
        ld      a,c
        out     ($10),a
        cp      $2c
        ret     z
        ld      b,64
        ld      de,13
dispByte:
        DWAIT
        ld      a,(hl)
        out     ($11),a
        add     hl,de
        djnz    dispByte
        ld      de,1-(13*64)
        add     hl,de
        inc     c
        jr      dispColumn
#endif
