;##################################################################
;
;   ZMercury (support for narrow-screen calculators)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   Copyright 2002 by Patrick Davidson.  This software may be freely
;   modified and/or copied with no restrictions.  There is no warranty.
;
;   This file was last updated November 27, 2004.
;
;##################################################################   

;############## Read LCD to 13x64 space at (HL)

Read_LCD:
        ld      c,$20
readColumn: 
        DWAIT
        ld      a,c
        out     ($10),a
        cp      $2c
        ret     z
        DWAIT
        ld      a,$80
        out     ($10),a
        DWAIT
        in      a,($11)
        ld      b,64
        ld      de,13
readByte:
        DWAIT
        in      a,($11)
        ld      (hl),a
        add     hl,de
        djnz    readByte
        ld      de,1-(13*64)
        add     hl,de
        inc     c
        jr      readColumn

;############## Interrupt stuff

INT_INSTALL:
        ld      (smc_intwhere+1),hl
        ld      hl,_timer_interrupt
        ld      de,interrupt_entry
        ld      bc,_timer_interrupt_end-_timer_interrupt
        ldir

        ld      hl,interrupt_table
        ld      (hl),interrupt_byte
        ld      bc,256
        call    OTH_FILL

        ld      a,interrupt_reg
        ld      i,a

        im      2
        ret

INT_REMOVE:
        im      1
        ret           

_timer_interrupt:
        push    af
smc_intwhere:
        call    $1234
        pop     af
        jp      $38
_timer_interrupt_end:

;############## Basic functions

DO_LD_HL_MHL:
        ld      a,(hl)
        inc     hl
        ld      h,(hl)
        ld      l,a
        ret

;############## Contrast adjustment and input

#ifdef __TI82__
CONTRAST_MAX    =$21
CONTRAST_ADJ    =$1E
#else
CONTRAST_MAX    =$27
CONTRAST_ADJ    =$18
#endif
