;##################################################################
;
;   ZMercury for non-TI85 calculators
;
;   Programmed by Patrick Davidson (pad@ocf.berkeley.edu)
;        
;   Copyright 2011 by Patrick Davidson.  This software may be freely
;   modified and/or copied with no restrictions.  There is no warranty.
;
;   This file was last updated August 1, 2011.
;
;##################################################################

;############## Simulation of Usgard functions

OTH_FILL:
        ld      d,h
        ld      e,l
        inc     de
        ldir
        ret

OTH_ARROW:
        ld      a,%00111111
        out     (1),a
        push    ix
        pop     ix
        in      a,(1)
        or      %00001111
        ld      b,a
        ld      a,%01111110
        out     (1),a
        push    ix
        pop     ix
        in      a,(1)
        and     b
        ret

;############## GET_KEY replacement

#ifdef __TI86__
GET_KEY:
        push    hl
        push    de
        push    bc
        ld      e,0                     ; E = GET_KEY result
        ld      hl,getkeylastdata       ; HL = ptr to last read's table
        ld      a,$fe                   ; A = key port mask
        ld      d,1                     ; D = individual key's mask
        ld      c,0                     ; C = key number counter
gkol:   out     (1),a
        ld      b,8                         
        push    af
gkl:    inc     c
        in      a,(1)
        and     d
        jr      nz,nokey
        ld      a,(hl)
        and     d
        jr      z,nokey
        ld      e,c
nokey:  rlc     d
        djnz    gkl
        in      a,(1)
        ld      (hl),a
        pop     af
        inc     hl
        rlca     
        cp      $7F
        jr      nz,gkol
        ld      a,e
        pop     bc
        pop     de
        pop     hl
        ret

getkeylastdata:
        .db     $ff,$ff,$ff,$ff,$ff,$ff,$ff
#endif

#ifdef TI83P
GET_KEY:
        bcall(_getcsc)
        ret
#endif

#ifdef TI83
GET_KEY:
        bcall(_getcsc)
        ret
#endif

