;##################################################################
;
;   ZMercury - High score handling
;
;   Programmed by Patrick Davidson (pad@ocf.berkeley.edu)
;        
;   Copyright 2011 by Patrick Davidson.  This software may be freely
;   modified and/or copied with no restrictions.  There is no warranty.
;
;   This file was last updated June 21, 2011.
;
;##################################################################

;############## Display high score table

show_table:
        ROM_CALL(CLEARLCD)
#ifdef NARROW
        ld      hl,0
        ld      (CURSOR_ROW),hl
#else
        ld      (CURSOR_ROW),de
#endif
        ld      hl,high_msg
        ROM_CALL(D_ZT_STR)
        ld      hl,scores
        ld      b,7
put_loop:
        push    hl
        ld      a,8
        sub     b
        ld      (CURSOR_ROW),a
        xor     a
        ld      (CURSOR_COL),a
        push    bc
        ROM_CALL(D_ZT_STR)
        pop     bc
        pop     hl
        ld      de,NAMELEN+1
        add     hl,de
        ld      a,8
        sub     b
        rrca
        ld      e,a
        or      $fc
        ld      d,a
        ld      a,e
        and     $80
        or      32-SCORELEN
        ld      e,a

        push    hl
        push    bc
        ld      a,8
        sub     b
        add     a,a
        add     a,a
        add     a,a
        inc     a
        ld      b,SCORELEN
        ld      c,2
        call    DISPLAY_BCD_XY
        pop     bc
        pop     hl
        inc     hl
        inc     hl
        inc     hl
        djnz    put_loop
        ret

;############## Wait to exit table display

wait_key:
        call    GET_KEY
wait_loop:
        call    GET_KEY
#ifdef NARROW
        cp      KEY_CODE_MODE
        ret     z
        cp      KEY_CODE_CLEAR
        ret     z
        cp      KEY_CODE_ENTER
#else
        cp      K_EXIT
        ret     z
        cp      K_CLEAR
        ret     z
        cp      K_ENTER
#endif
        jr      nz,wait_loop
        ret

;############## Show final scoring information

enter_table:
        ld      hl,scores_end-SCORELEN
        ld      de,score
        ld      b,SCORELEN
        call    CP_BCD
        jp      c,no_score

;############## Add player to high scores

        ld      hl,scores_end-ENTRYLEN          ; Put your score in bottom
        ld      b,NAMELEN
loop_space:
        ld      (hl),' '
        inc     hl
        djnz    loop_space
        ld      (hl),0
        inc     hl
        ex      de,hl
        ld      hl,score
        ld      bc,SCORELEN
        ldir
        
        ld      b,6                             ; Bubble it towards the top
        ld      de,scores_end-SCORELEN          ; DE = score of entry to move
loop_bubble:                             
        ld      hl,-(ENTRYLEN)
        add     hl,de                           ; HL = score of previous item

        push    bc
        push    de
        ld      b,SCORELEN
        call    CP_BCD
        pop     de
        pop     bc

        jr      z,bubble_up
        jr      c,no_bubble_up
bubble_up:

        push    bc
        inc     de                            
        inc     de                              ; DE = last byte of entry
        ld      hl,-(ENTRYLEN)
        add     hl,de                           ; HL = last byte of previous
        ld      b,0+ENTRYLEN
loop_exchange:
        ld      a,(de)
        ld      c,a
        ld      a,(hl)
        ld      (de),a
        ld      (hl),c
        dec     hl
        dec     de                              
        djnz    loop_exchange                   
        pop     bc                              ; DE = last byte of previous
        dec     de                              ; DE = score of previous
        dec     de

        djnz    loop_bubble

no_bubble_up:

        push    bc
        push    de
        call    show_table

        ld      hl,0
        ld      (CURSOR_ROW),hl
        ld      hl,highscore_prompt
        ROM_CALL(D_ZT_STR)
        pop     de
        pop     bc
        ld      ix,-(NAMELEN+1)
        add     ix,de
        ld      c,b
        ld      b,0
        inc     c
        ld      (CURSOR_ROW),bc

;############## Prompt for name entry

input_name:
     ;   ld      b,0
enter_name_loop:
        call    GET_KEY
        or      a
        jr      z,enter_name_loop
#ifdef NARROW
        cp      KEY_CODE_DEL
#else
        cp      K_DEL
#endif
        jr      z,backup
#ifdef NARROW
        cp      KEY_CODE_ENTER
#else
        cp      K_ENTER
#endif
        ret     z
        ld      c,a
        ld      a,NAMELEN
        cp      b
        jr      z,enter_name_loop
        ld      hl,chartable-10
        ld      e,c
        ld      d,0
        add     hl,de
        ld      a,(hl)
        ld      (ix),a
        ROM_CALL(TX_CHARPUT)
        inc     b
        inc     ix
        jr      enter_name_loop
backup: xor     a
        cp      b
        jr      z,enter_name_loop
        dec     b
        dec     ix
        ld      (ix),32
        ld      hl,CURSOR_COL
        dec     (hl)
        ld      a,32
        ROM_CALL(TX_CHARPUT)
        dec     (hl)
        jr      enter_name_loop

chartable:
#ifdef NARROW
        .db     ":WRMH."
        .db     "..0VQLG!..ZUPKFC"
        .db     "..YTOJEBX.>SNIDA"
        .db     ".12345.."
#else
        .db     "XTOJE."
        .db     ". WSNID!.ZVRMHC?"
        .db     ".YUQLGB#x~+PKFA|"
        .db     "@54321.~+"
#endif

;############## Sorry, no highscore

no_score:
        ROM_CALL(CLEARLCD)
        ld      hl,0
        ld      (CURSOR_ROW),hl
        ld      hl,finalscore
        ROM_CALL(D_ZT_STR)

        ld      a,9
        ld      c,SCORELEN-1
        ld      hl,score
        ld      b,SCORELEN      
        call    DISPLAY_BCD_XY
        jp      wait_key

#ifdef NARROW
finalscore:
        .db     "GAME OVER !!!!!!"
        .db     "Final Score:    "
        .db     "You did not get "
        .db     "a high score.   "
        .db     "Press ENTER to  "
        .db     "to continue.",0
high_msg:
        .db     "High Scores:    ",0
highscore_prompt:
        .db     "Enter your name:",0
#else
finalscore:
        .db     "----> GAME OVER <----"
        .db     "Your Final Score:    "
        .db     "You did not get a    "
        .db     "high score.  Press   "
        .db     "ENTER to continue.",0
high_msg:
        .db     "All-Time High Scores:",0
highscore_prompt:
        .db     "-> Enter Your Name <-",0
#endif
