;##################################################################
;
;   ZMercury (terrain code)
;                                                                     
;   Programmed by Patrick Davidson (pad@ocf.berkeley.edu)
;        
;   Copyright 2011 by Patrick Davidson.  This software may be freely
;   modified and/or copied with no restrictions.  There is no warranty.
;
;   This file was last updated August 1, 2011.
;
;##################################################################     

scroll_terrain:
        call    shift_terrain

        ld      hl,terrain_count
        inc     (hl)
        ld      a,(hl)
        cp      8
        ret     nz
        ld      (hl),0

        ld      a,(game_status)
        or      a
        jr      z,not_stopped
        ld      a,(enemies_left)
        or      a
        jr      nz,terrain_stopped
        ld      (game_status),a
not_stopped:

        inc     hl
        ld      a,(hl)
        inc     a
        cp      TERRAIN_WIDTH
        jr      nz,terrain_ok
        ld      a,(difficulty_level)     ; boost difficulty on looping around
        add     a,4
        ld      (difficulty_level),a
        xor     a
terrain_ok:
        ld      (hl),a

        ld      bc,BUFF_WIDTH-1
        call    draw_column

        ld      a,(hl)
        or      a
        call    nz,enemy_entry

;############## update the terrain list (for restore)
        
        ld      a,(terrain_x)
update_terrain_list:
        ld      de,column_list
        ld      hl,column_list+1
        ld      bc,BUFF_WIDTH-1
        ldir
        ld      (column_list+BUFF_WIDTH-1),a
        ret

;############## scroll terrain when in open area

terrain_stopped:
        ld      hl,(terr_buffer)
        ld      bc,BUFF_WIDTH-1
        add     hl,bc                   ; HL => end of line on top row
        ld      a,255
        ld      b,TERRAIN_HEIGHT
        ld      de,BUFF_WIDTH
loop_terr_stopped:
        ld      (hl),a
        add     hl,de
        djnz    loop_terr_stopped

        jr      update_terrain_list

;############## Render a column (BC = screen offset, A = column #)

draw_column:
        ld      hl,terrain_map
        call    ADD_HL_A                ; HL => this columns start in map
        ex      de,hl
        ld      hl,(terr_buffer)
        add     hl,bc                   ; HL => end of line on top row
        ex      de,hl                   ; DE => end of line on top row
        ld      bc,(TERRAIN_TILES<<8)+255
column_loop:
        ld      a,(hl)                  ; A = brick #
        push    hl
        push    bc
        ld      hl,tile_images
        add     a,a                   
        add     a,a
        add     a,a
        call    ADD_HL_A                ; HL => brick image
        ld      b,8                     
block_loop:
        ldi                             ; copy one row, advance pointers
        ld      a,BUFF_WIDTH-1          ; add 16 to DE (next screen line)
        add     a,e
        ld      e,a
        jr      nc,bld
        inc     d
bld:    djnz    block_loop
        pop     bc
        pop     hl
        ld      a,TERRAIN_WIDTH         ; move to next row of map
        call    ADD_HL_A
        djnz    column_loop
        ret

;############## Shift terrain left

shift_terrain:
        ld      hl,(terr_buffer)
        ld      de,TERRAIN_SIZE
        add     hl,de
        ld      b,TERRAIN_HEIGHT
        jp      scroll_buffer

;############## Restore column display

restore_terrain:
        ld      hl,column_list
        ld      bc,0
lrc:    push    hl
        push    bc
        ld      a,(hl)
        cp      -1
        call    nz,draw_column
        pop     bc
        pop     hl
        inc     hl
        inc     c
        ld      a,BUFF_WIDTH
        cp      c
        jr      nz,lrc

        ld      a,(terrain_count)
        or      a
        ret     z
        ld      b,a
lrs:    push    bc
        call    shift_terrain
        pop     bc
        djnz    lrs
        ret

;############## Level data

tile_images:
#include "terrain.i"

terrain_map:
#include "map.i"

TERRAIN_WIDTH   =80
