;##################################################################
;
;   ZMercury (main code)
;                                                                     
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   Copyright 2005 by Patrick Davidson.  This software may be freely
;   modified and/or copied with no restrictions.  There is no warranty.
;
;   This file was last updated April 1, 2005.
;
;##################################################################     

main:   ld      hl,timer_interrupt      ; Initialize interrupt
        call    INT_INSTALL

        ROM_CALL(CLEARLCD)
        call    initialize_display_buffers
        
        ld      hl,saved_flag
        ld      a,(hl)
        or      a
        jr      z,no_restore

        ld      (hl),0
        call    restore_terrain
        jr      pre_main_loop

no_restore:
        ld      hl,zero_start
        ld      (hl),0
        ld      bc,zero_end-zero_start-1
        call    OTH_FILL

        ld      a,-1
        ld	(terrain_x),a
        ld      (contrastkeys),a

        ld      hl,column_list
        ld      bc,BUFF_WIDTH
        ld      (hl),a
        call    OTH_FILL

        xor     a
        ld      (timer),a
        ld      a,3
        ld      (terrain_count),a
        ld      a,42
        ld      (player_x),a
        ld      a,60
        ld      (player_y),a
        ld      hl,$1
        ld      (shield),hl

        call    title_screen

;############## The main loop

pre_main_loop:
        call    show_panel

main_loop:
        ld      hl,(game_timer)
        inc     hl
        ld      (game_timer),hl
        call    scroll_terrain
        call    scroll_stars
        call    draw_background
        call    move_player
        call    handle_player_bullets
        call    process_enemies
        call    process_enemy_bullets
        call    hit_enemy

        call    wait_next_frame
#ifndef NARROW
        ld      hl,$ffa0
        ld      bc,15
        ld      (hl),0
        call    OTH_FILL
        ld      a,(speed)
        inc     a
        ld      hl,$ffaf
b:      ld      (hl),-1
        dec     hl
        dec     a
        jr      nz,b
#endif
        call    display_buffer
        call    show_lives
        call    show_score
        ld      a,(shield)
        rla
        jr      nc,main_loop

;############## Game over screen

game_over:
        call    OTH_ARROW
        bit     6,a
        jr      z,finalexit

        call    enter_table
        call    show_table
loopexit:
        call    GET_KEY
        or      a
        jr      z,loopexit
finalexit:
        call    INT_REMOVE
        jp      GET_KEY

;############## The very simple interrupt

timer_interrupt:
        push    hl
        ld      hl,timer
        inc     (hl)
        pop     hl
        ret
