;##################################################################
;
;   Z M E R C U R Y     F O R     T I - 8 2     ( A C E )
;
;   Programmed by Patrick Davidson (pad@ocf.berkeley.edu)
;        
;   Copyright 2011 by Patrick Davidson.  This software may be freely
;   modified and/or copied with no restrictions.  There is no warranty.
;
;   This file was last updated August 1, 2011.
;
;##################################################################     

#define __TI82__
#define NARROW

#include    "acebeta.inc"

K_EXIT          =$37

;############## Memory arrangement
;
; Free areas:
;
; 128 bytes at TEXT_MEM
; 2K bytes at $9000 (SH_BUF)
; 768 bytes at GRAPH_MEM
;
; use as follwes:
;
; TEXT_MEM      variables (as much as needed - should all fit)
; GRAPH_MEM     starfield buffer (13*58 = 754 bytes)
; $9000-$9100   interrupt table (257 bytes)
; $9101-$9440   terrain buffer (13*64 = $340 bytes)
; $9441-$9780   display buffer (13*64 = $340 bytes)
; $9797-$97ff   interrupt routine (should fit easily)
                     
GFX_BUFFER      =$9442
interrupt_entry =$9797
interrupt_byte  =$97
interrupt_table =$9000
interrupt_reg   =$90

#include "zmercury.i"
#include "keys.i"

        .org    START_ADDR

        .db     "ZMercury 0.70",0

        ld      (iy+13),0               ;don't overwrite text memory

        ld      hl,GFX_BUFFER
        ld      (_GFX_BUFFER),hl

        ld      hl,GRAPH_MEM
        ld      (star_buffer),hl
        ld      hl,$9101
        ld      (terr_buffer),hl

CLEARLCD        =CLEAR_LCD

;############## Include remainder of game files
        
#include "zmerc.asm"
#include "lib.asm"
#include "gfx.asm"
#include "terrain.asm"
#include "drwspr.asm"
#include "images.asm"
#include "player.asm"
#include "bullets.asm"
#include "vars.asm"
#include "info.asm"
#include "enemies.asm"
#include "entry.asm"
#include "collide.asm"
#include "hitenemy.asm"
#include "ebullets.asm"
#include "eshoot.asm"
#include "scores.asm"
#include "title.asm"
#include "lib12.asm"
#include "non85.asm"
#include "bonus.asm"

;############## D_HL_DECI replacement

D_HL_DECI:
        push    hl
        ld      hl,(CURSOR_ROW)
        push    hl
        ld      hl,spaces
        ROM_CALL(D_ZT_STR)
        pop     hl
        ld      (CURSOR_ROW),hl
        pop     hl
        call    HL_DECI
        ROM_CALL(D_ZT_STR)
        ret

spaces: .db     "     ",0

        .end
