;##################################################################
;
;   Z M E R C U R Y     F O R     T I - 8 5    ( Z S h e l l)
;
;   Programmed by Patrick Davidson (pad@ocf.berkeley.edu)
;        
;   Copyright 2011 by Patrick Davidson.  This software may be freely
;   modified and/or copied with no restrictions.  There is no warranty.
;
;   This file was last updated August 1, 2011.
;
;##################################################################     

#define __TI85__
             
#include "usgard.h"

GFX_BUFFER      =$8642
DO_LD_HL_MHL    =LD_HL_MHL

#include "zmercury.i"          

        .org    $9800

        .db     "ZMercury 0.70 by Patrick D",0
        
        ld      hl,(PROGRAM_ADDR)
        ld      de,memory_initialize-$9800
        add     hl,de
        ld      de,$800F
        ld      bc,memory_initialize_end-memory_initialize
        ldir
        jp      $800F                             

;############## MEMORY SWAPPING CODE (RUN FROM DELC_LEN)

memory_initialize:
        nop
        ld      hl,(PROGRAM_ADDR)
        ld      de,$9800
        ld      bc,end_of_code-$9800
        call    memory_exchange

        call    main_program
        call    GET_KEY

        ld      de,(PROGRAM_ADDR)
        ld      hl,$9800
        ld      bc,end_of_code-$9800

memory_exchange =$-memory_initialize+$800F

#include "exchange.asm"

memory_initialize_end:

;############## START OF NORMAL CODE (RUN WITH PROGRAM STARTING AT $9800)

main_program:
        ld      hl,GFX_BUFFER
        ld      (_GFX_BUFFER),hl
        set     0,(iy+3)
        ld      hl,(VAT_END)               ; Locate double-buffer page
        ld      de,-VISIBLE_SIZE-TERRAIN_SIZE
        add     hl,de
        ld      de,(FIRST_FREE)
        call    CP_HL_DE
        jr      nc,allocok
        call    CLEARLCD
        ld      (CURSOR_ROW),de
        ld      hl,nomem
        call    D_ZT_STR
        jp      OTH_PAUSE 

nomem:  .db     "ERROR: 2.1K FREE RAM"
        .db     "REQUIRED!",0

allocok:
#define CONTIGUOUS_BUFFERS
        ld      (star_buffer),hl
        ld      de,VISIBLE_SIZE
        add     hl,de
        ld      (terr_buffer),hl

;############## Include remainder of game files
        
#include "zmerc.asm"
#include "lib.asm"
#include "gfx.asm"
#include "terrain.asm"
#include "drwspr.asm"
#include "images.asm"
#include "player.asm"
#include "bullets.asm"
#include "vars.asm"
#include "info.asm"
#include "enemies.asm"
#include "entry.asm"
#include "collide.asm"
#include "hitenemy.asm"
#include "ebullets.asm"
#include "eshoot.asm"
#include "scores.asm"
#include "title.asm"
#include "bonus.asm"

end_of_code:

        .end
