;##################################################################
;
;   ZMercury (Variable and data structure defintions)
;
;   Programmed by Patrick Davidson (pad@ocf.berkeley.edu)
;        
;   Copyright 2011 by Patrick Davidson.  This software may be freely
;   modified and/or copied with no restrictions.  There is no warranty.
;
;   This file was last updated June 22, 2011.
;
;##################################################################   

;############## Player bullet structure

pb_type         =0              ; 0 = not present, 1 = basic
pb_x            =1              ; X coordinate
pb_w            =2
pb_y            =3              ; Y coordinate
pb_h            =4
pb_dmg          =5              ; amount of damage caused
pb_image        =6
pb_size         =8              ; structure size

pb_num          =13

;############## Enemy structure

e_type          =0
e_x             =1
e_w             =2
e_y             =3
e_h             =4
e_dmg           =5
e_image         =6
e_counter       =8
e_phase         =9
e_size          =10

e_num           =12

;############## Enemy bullet structure

eb_type         =0
eb_x            =1
eb_w            =2
eb_y            =3
eb_h            =4
eb_dmg          =5
eb_image        =6
eb_size         =8

eb_num          =12

;############## Screen descriptions
;
; The visible gameplay screen is 58 pixels tall, allowing 6 lines at the
; bottom of the screen for data display.
;
; There are 3 screen buffers active in the game in addition to the video
; buffer.  The stars and terrain each have their own background buffers.
; Also, a drawing buffer is made each frame combining these two, in which
; the final screen is generated.  The star buffer is the same size as the
; gameplay area, but the terrain buffer is taller (with a few lines skipped
; at the top and the bottom).
;
; On the TI-85 and TI-86, the drawing buffer (GFX_BUFFER) is only 58 lines
; tall (matching the gameplay area) while the remaining 6 lines (which hold
; the information panel) are drawn straight to the screen.  On the lower
; calculators it is a full 64 lines tall, and everything is drawn there
; first and then copied to the display controller.

#ifndef NARROW
BUFF_WIDTH      =17             ; width of graphics buffer in bytes
MIN_PLAYER_X    =7
MAX_PLAYER_X    =57
#else
BUFF_WIDTH      =13             ; width of graphics buffer in bytes
MIN_PLAYER_X    =39
MAX_PLAYER_X    =57
#endif

TERRAIN_HEIGHT  =64             ; height of terrain buffer
TERRAIN_SIZE    =BUFF_WIDTH*64  ; size of graphics buffer in bytes
TERRAIN_TILES   =8              ; height in tiles
TERRAIN_SKIP    =3              ; lines to skip

VISIBLE_HEIGHT  =58             ; size of area to copy
VISIBLE_SIZE    =BUFF_WIDTH*58  ; size in bytes of visible area

MIN_Y           =35             ; sprite limits
MAX_Y           =35+VISIBLE_HEIGHT

;############## Temporary variables

star_buffer     =TEXT_MEM       ; pointer to background (star) buffer
terr_buffer     =TEXT_MEM+2     ; pointer to foreground (terrain) buffer
timer           =TEXT_MEM+4     ; incremented every interrupt                
speed           =TEXT_MEM+5     ; actual time taken in last frame
test_coords     =TEXT_MEM+6     ; 4 bytes for collision check
test_damage     =TEXT_MEM+10
temp_address    =TEXT_MEM+11
justfired       =TEXT_MEM+13
contrastkeys    =TEXT_MEM+14
enemies_left    =TEXT_MEM+15
data_address    =TEXT_MEM+16
temp_enemy      =TEXT_MEM+18    ; template for enemy array filling
_GFX_BUFFER     =TEXT_MEM+28
inst_already    =TEXT_MEM+30
terrain_ptr     =TEXT_MEM+31    ; pointer to next terrain empty to read
terrain_repeat  =TEXT_MEM+33    ; number of repeats of this tile so far