
// AUTOGENERATED! DO NOT MODIFIED !!!!

/* -*- Mode: C; c-basic-indent: 2; indent-tabs-mode: nil -*- */ 
/* $Id: MinTransM.nc,v 1.10 2003/06/22 01:08:44 ttong Exp $ */
/*////////////////////////////////////////////////////////*/
/**
 * 
 * Author: Terence Tong, Alec Woo
 */
/*////////////////////////////////////////////////////////*/
module MinTransM {
  provides {
    interface StdControl;
    command void chooseParent();
  }
  uses {
    interface RouteHelp;
    interface RouteState;
  }
}
implementation {
  enum {
    SWITCH_THRESHOLD = 192,
    MAX_ALLOWABLE_LINK_COST = 256 * 6
  };
  /*////////////////////////////////////////////////////////*/
  /**  
   * So what the heck is this? The idea is to have a higher 
   * precision but avoid using floating point
   * the cost is stored in a finer granularity. cost of 4 means 1 expected transmission.
   * this is the unit for the cost in route message
   * the idea is to do cost = parnet cost + 1 / (sendEst * receiveEst)
   * notice that sendEst and receiveEst is using one byte to simulate a float
   * so it would be parent cost + 65535 / (sendEst * receiveEst)
   * but check this out, we are doing a integer division, there will be * a lose of information
   * so the approach iz to scale up everything
   * cost * 256 + 65536 * 256 / (sendEst * receiveEst). we use this to compare and finally
   * we round off and scale down back to the unit (cost of 4 equal 1) when we pickED our parent
   * @author: terence
   * @param: cost, parent cost
   * @param: sendEst, send estimation, uint8_t floating point
   * @param: receiveEst, receive estimation, uint8_t floating point
   * @return: uint32_t intermmediate cost
   */
  uint32_t evaluateCost(cost_t cost, uint8_t sendEst, uint8_t receiveEst) {
    uint32_t transEst = (uint32_t) sendEst * (uint32_t) receiveEst;
    uint32_t immed = ((uint32_t) 1 << 24);
    if (transEst == 0) return ((uint32_t) 1 << (uint32_t) 16);
    // DO NOT change this LINE! mica compiler is WEIRD!
    immed = immed / transEst;
    immed += ((uint32_t) cost << 6);
    return immed;
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * The following functions are just set parent function. nothing special
   * @author: terence
   * @param: 
   * @return: 
   */
  void giveUp() {
    call RouteHelp.setInfo(ROUTE_INVALID, ROUTE_INVALID, ROUTE_INVALID);    
  }
  void setOldParent(address_t oldParent, uint8_t oldParentHop, uint32_t oldParentCost) {
    uint32_t finalCost;
    finalCost = oldParentCost >> 6;
    call RouteHelp.setInfo(oldParent, oldParentHop, finalCost);
  }
  void switchParent(address_t currentParent, uint8_t currentHop, uint32_t currentCost) {
    uint32_t finalCost;
    finalCost = currentCost >> 6;
    call RouteHelp.setInfo(currentParent, currentHop, finalCost);
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * choose parent based on alec's algorithm. notice that this is purely the mrp,
   * not th hybrid. It goes through all the neighbor on eby one and 
   * @author: terence
   * @param: void
   * @return: void
   */
  command void chooseParent() {
    address_t id[ROUTE_TABLE_SIZE], parent, oldParent, currentParent = (address_t) ROUTE_INVALID;
    uint8_t avaliableNeighbors, i, isDirectChild;
    uint8_t hop, sendEst, receiveEst;
    bool isDescendent;
    cost_t cost;
    uint32_t resultingCost, currentCost = (uint32_t) -1, oldParentCost = (uint32_t) -1;
    uint8_t currentHop = ROUTE_INVALID;
    uint32_t oldParentLinkCost = (uint32_t) -1;
    uint32_t resultingLinkCost = (uint32_t) -1, currentLinkCost = (uint32_t) -1;
    uint8_t oldParentHop = (uint8_t) -1;
    uint8_t currentSendEst = 0, currentReceiveEst = 0;
    int32_t diffCost = (uint32_t) -1;
    uint8_t oldReceiveEst = 0, oldSendEst = 0;
    cost_t myOldCost;
    if (TOS_LOCAL_ADDRESS == BASE_STATION) return;
    oldParent = call RouteState.getParent();
    myOldCost = call RouteState.getCost();
    // clear the old debug info
    // get the top neighbor based on pathest
    avaliableNeighbors = call RouteHelp.getNeighbors(id, ROUTE_TABLE_SIZE);
    for (i = 0; i < avaliableNeighbors; i++) {
      // kill all the children
      call RouteHelp.getNeighborInfo(id[i], &parent, &hop, &cost, 
				     &sendEst, &receiveEst, &isDescendent);
      // kill all those whose parent is myself
      isDirectChild = (parent == TOS_LOCAL_ADDRESS);
      // avoid divided by zero exception, don't bother if infomation are invalid
      if (sendEst < 25 || receiveEst < 25) continue;
      if (cost == (cost_t) ROUTE_INVALID) continue;
      if (parent == (address_t) ROUTE_INVALID) continue;
      if (hop == (uint8_t) ROUTE_INVALID) continue;
      if (isDescendent || isDirectChild) continue;
      resultingCost = evaluateCost(cost, sendEst, receiveEst);
      resultingLinkCost = evaluateCost(0, sendEst, receiveEst);
      // if it is my old parent, save down its info for later comparisoin
      if (id[i] == oldParent) {
        oldParentCost = resultingCost; 
        oldParentLinkCost = resultingLinkCost;
        oldParentHop = hop + 1;
        oldReceiveEst = receiveEst;
        oldSendEst = sendEst;
        continue;
      }
      // if it is not my child and it is greater than the currentCost
      if (currentCost > resultingCost) {
	// save down parent, hop, pathest
	currentLinkCost = resultingLinkCost;
	currentCost = resultingCost;
	currentParent = id[i];
	currentHop = hop + 1;
        currentSendEst = sendEst;
        currentReceiveEst = receiveEst;
      }
    }
    
    if (currentParent == (address_t) ROUTE_INVALID && oldParent == (address_t) ROUTE_INVALID) {
      giveUp();
      return;
    }
    
    if (currentParent == (address_t) ROUTE_INVALID) {
      // that means oldParent is valid
      if (oldParentLinkCost > MAX_ALLOWABLE_LINK_COST) {
        // my old parent is not good either, give up
        giveUp();
        return;
      }
      // stick with same parent
      setOldParent(oldParent, oldParentHop, oldParentCost);
      return;
    }
    if (oldParent == (address_t) ROUTE_INVALID) {
      // positive when my best neighbor is bigger than my cost (then no no!)
      diffCost = (int32_t) currentCost - ((int32_t) myOldCost) << ((int32_t) 6);
      
      // that means current parent (or best parent) is valid
      if (currentLinkCost > MAX_ALLOWABLE_LINK_COST || diffCost > 0) {
        // best parent is no good, give up
        giveUp();
        return;
      }
      // use the new parent
      switchParent(currentParent, currentHop, currentCost);
      return;
    }
    diffCost = (int32_t) oldParentCost - (int32_t) currentCost; 
      // now both are valid
    if (diffCost <= SWITCH_THRESHOLD) {
      if (oldParentLinkCost > MAX_ALLOWABLE_LINK_COST) {
        giveUp();
        return;
      }
      // choose the old parent
      setOldParent(oldParent, oldParentHop, oldParentCost);
      return;
    }
    // after this currentParent must be better and parent not invalid
    // if current parent has a bad link
    if (currentLinkCost > MAX_ALLOWABLE_LINK_COST) {
      if (oldParentLinkCost > MAX_ALLOWABLE_LINK_COST) {
        // both are bad
        giveUp();
        return;
      }
      // still pick the old parent in this case
      setOldParent(oldParent, oldParentHop, oldParentCost);
      return;
    }
    
    switchParent(currentParent, currentHop, currentCost);
    
  }
  command result_t StdControl.init() {
    return SUCCESS;
  }
  command result_t StdControl.start() {
    if (TOS_LOCAL_ADDRESS == BASE_STATION) {
      // basestatino has cost of 0
      call RouteHelp.setInfo(TOS_UART_ADDR, 0, 0);
    } else {
      // rest of it should be hugh number
      call RouteHelp.setInfo(ROUTE_INVALID, ROUTE_INVALID, ROUTE_INVALID);
    }
    return SUCCESS;
  }
  command result_t StdControl.stop() {
    return SUCCESS;
  }
}
