
// AUTOGENERATED! DO NOT MODIFIED !!!!

/* -*- Mode: C; c-basic-indent: 2; indent-tabs-mode: nil -*- */ 
/* $Id: ParentSelectionM.nc,v 1.18 2003/06/22 01:08:45 ttong Exp $ */
/*////////////////////////////////////////////////////////*/
/**
 * A Parent Selection component
 * Author: Terence Tong, Alec Woo
 */
/*////////////////////////////////////////////////////////*/
includes RoutingStack;
module ParentSelectionM {
  provides {
    interface SendMsg as Incoming[uint8_t id];
    interface StdControl;
    interface Retransmit;
    interface RetransmitSignal;
    interface ReceiveMsg as OutForwardReceive;
  }
  uses {
    interface SendMsg as Outgoing[uint8_t id];
    interface RouteHelp;
    interface RouteState;
    interface Timer;
    interface Timer as OffsetTimer;
    interface StdControl as CommControl;
    interface ReceiveMsg as InForwardReceive;
    command void chooseParent();
  }
}
implementation {
  uint16_t routeUpdateInterval = ROUTE_FREQ; 
  /*////////////////////////////////////////////////////////*/
  /**
   * This function start the route timer at the right frequency
   * @author: terence
   * @param: void
   * @return: void
   */
  void scheduleTimer() {
    uint16_t randomizedTime;
    // minimium route message interval
    randomizedTime = routeUpdateInterval;
    // call the timer
    call Timer.start(TIMER_REPEAT, randomizedTime);
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * Route timer fired. So what do we do. We decrease the liveliness of the table
   * then we choose a parent. send a route packet tell every body your new info
   * schedule next timer
   * @author: terence
   * @param: void
   * @return: success
   */
  task void timerFired() {
    address_t parent, oldParent;
    call RouteHelp.updateTable();
    oldParent = call RouteState.getParent();
    call chooseParent();
    parent = call RouteState.getParent();
    if (parent != oldParent) {
      call RouteHelp.clearChildren();
    }
    call RouteHelp.sendRoute();
  }
  task void cycleDetected() {
    call chooseParent();
    call RouteHelp.sendRoute();
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * The point of having this is to send route message in the middle of DATA_MSG
   * so that corrupting packet and conflicting packet will be minimize
   * @author: terence
   * @param: 
   * @return: 
   */
  event result_t OffsetTimer.fired() {
    scheduleTimer();
    return SUCCESS;
  }
  event result_t Timer.fired() {
    post timerFired();
    return SUCCESS;
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * when a data packet comes, we filled out the header
   * @author: terence
   * @param: msg, the msg going to be sent
   * @param: isOriginated: 1 if originated from here, 0 if forward
   * @return: void
   */
  void fillHeader(TOS_MsgPtr msg) {
    // MHSenderHeader *mhsenderHeader = (MHSenderHeader *) &msg->data[msg->length - MHSENDER_HEADER_OFFSET];
    MHSenderHeader *mhsenderHeader = (MHSenderHeader *) &msg->data[msg->length - sizeof(MHSenderHeader)];
    uint8_t isOriginated = (mhsenderHeader->realSource == TOS_LOCAL_ADDRESS);
    // we get some new information about our children, check cycle again
    if (call RouteHelp.isCycle()) {
      // if yes, choose parent, and send route message tell every one about the new info
      call RouteHelp.fillDropHeader(msg);
      post cycleDetected();
      return;
    }
    // fill the header
    call RouteHelp.fillHeader(msg, isOriginated);
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * ask routing to fill it out and send it to virtual comm
   * @author: terence
   * @param: msg, the message mhsender want to send out
   * @param: isOriginated: it is a forward packet, or oritinated from this mote
   * @return: the result of the virtual comm sending
   */
  command result_t Incoming.send[uint8_t id](uint16_t address, uint8_t length, TOS_MsgPtr msg){
    // ask Routing to fill out header
    // Filling header is simply to fill out the address on the AM message
    // note that:  if parent is invalid, destination is BCAST
    fillHeader(msg);
    // call VCSend to really send data out
    return call Outgoing.send[id](msg->addr, msg->length, msg);
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * signal up when we get a senddone from virtual comm
   * @author: terence, alec
   * @param: msg, the message we just sent
   * @param: delivered, true when it still fail after maximum number of retransmission
   * @return: result
   */
  event result_t Outgoing.sendDone[uint8_t id](TOS_MsgPtr msg, result_t delivered) {
    return signal Incoming.sendDone[id](msg, delivered);
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * data message from the radio get signal up.
   * we need to update some of our state before we signal up the application
   * @author: terence, alec
   * @param: msg, received message from radio stack
   * @return: ptr to give b ack the radio to recycle
   */
  event TOS_MsgPtr InForwardReceive.receive(TOS_MsgPtr msg){
    TOS_MsgPtr ret = msg;
    if (msg->addr == TOS_LOCAL_ADDRESS){
      call RouteHelp.updateChildEntry(msg);
      ret = signal OutForwardReceive.receive(msg);
    }
    return ret;
  }
  command result_t StdControl.init() {
    call CommControl.init();
    return SUCCESS;
  }
  command result_t StdControl.start() {
    call OffsetTimer.start(TIMER_ONE_SHOT, routeUpdateInterval >> 1);
    call CommControl.start();
    return SUCCESS;
  }
  command result_t StdControl.stop() {
    call Timer.stop();
    call CommControl.stop();
    return SUCCESS;
  }
}
