
// AUTOGENERATED! DO NOT MODIFIED !!!!

/* -*- Mode: C; c-basic-indent: 2; indent-tabs-mode: nil -*- */ 
/* $Id: RouteHelperM.nc,v 1.14 2003/06/22 01:08:45 ttong Exp $ */
/*////////////////////////////////////////////////////////*/
/**
 * library of helper function for routing component
 * intenetion is to decouple algorithm with detail implementation
 * Author: Terence Tong, Alec Woo
 */
/*////////////////////////////////////////////////////////*/
includes RoutingStack;
#include "fatal.h"
includes AM;
module RouteHelperM {
  provides {
    interface RouteHelp;
    interface StdControl;
    interface ReceiveMsg as ReceiveRouteMsg;
    interface RouteState;
  }
  uses {
    interface SendMsg as VCSend;
    interface Estimator;
    interface ReceiveMsg as RouteReceive;
    interface ReceiveMsg as ReceiveAll;
    interface Leds;
  }
}
implementation {
  address_t parent;
  uint8_t hop;
  cost_t cost;
  uint8_t routeSending;
  TOS_Msg routeMsg;
  uint8_t estimatorTicks;
  typedef struct TableEntry {
    address_t id;
    uint8_t valid;
    uint8_t liveliness;
    address_t parent;
    uint8_t hop;
    cost_t cost;
    uint8_t receiveEst;
    uint8_t sendEst;
    uint8_t childLiveliness;
    uint8_t trackInfo[TRACK_INFO_SIZE];
  } TableEntry;
  TableEntry routeTable[ROUTE_TABLE_SIZE];
  /*////////////////////////////////////////////////////////*/
  /**
   * This is going to find an entry by node id, return the index of the table
   * @author: terence
   * @param: id
   * @return: index, if not found return ROUTE_INVALID
   */
  uint8_t findEntry(address_t id) {
    uint8_t i = 0;
    for (i = 0; i < ROUTE_TABLE_SIZE; i++) {
      if (routeTable[i].valid == 1 && routeTable[i].id == id) {
        return i;
      }
    }
    return ROUTE_INVALID;
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * This funciton determined which entry should be replace
   * in this case, we find the one with the lease send estimate
   * @author: terence
   * @param: void
   * @return: index of the table
   */
  uint8_t findEntryToBeReplaced() {
    uint8_t i = 0;
    uint8_t minSendEst = -1;
    uint8_t minSendEstIndex = ROUTE_INVALID;
    for (i = 0; i < ROUTE_TABLE_SIZE; i++) {
      if (routeTable[i].valid == 0) {
        return i;
      }
      if (routeTable[i].valid == 1 && minSendEst >= routeTable[i].sendEst) {
        minSendEst = routeTable[i].sendEst;
        minSendEstIndex = i;
      }
    }
    return minSendEstIndex;
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * This is going to make a new entry give an index and a id
   * @author: terence
   * @param: index, the index of the table
   * @param: id, the node id 
   * @return: void
   */
  void newEntry(uint8_t indes, address_t id) {
    routeTable[indes].id = id;
    routeTable[indes].valid = 1;
    routeTable[indes].parent = ROUTE_INVALID;
    routeTable[indes].hop = ROUTE_INVALID;
    routeTable[indes].cost = ROUTE_INVALID;  
    routeTable[indes].receiveEst = 0;
    routeTable[indes].sendEst = 0;
    routeTable[indes].childLiveliness = 0;
    call Estimator.clearTrackInfo(routeTable[indes].trackInfo);
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * it try to find a valid entry, if not, it will kill one, 
   * clear the entry return that index
   * @author: terence
   * @param: id, node id
   * @return: index
   */
  uint8_t findPreparedIndex(address_t id) {
    uint8_t indes = findEntry(id);
    if (indes == (uint8_t) ROUTE_INVALID) {
      indes = findEntryToBeReplaced();
      newEntry(indes, id);
    }
    return indes;
  }
  ////////////////////////////////////////////
  // packet format
  struct RoutePacket {
    address_t parent;
    uint8_t hop;
    cost_t cost;
    uint8_t estLength;
  };
  struct RoutePacketFeedBack {
    address_t id;
    uint8_t receiveEst;
  };
  command result_t StdControl.init() {
    return SUCCESS;
  }
  command result_t StdControl.start() {
    estimatorTicks = 1;
    return SUCCESS;
  }
  command result_t StdControl.stop() {
    return SUCCESS;
  }
  command void RouteHelp.setInfo(address_t inputParent, uint8_t inputHop, cost_t inputCost) {
    parent = inputParent;
    hop = inputHop;
    cost = inputCost;
  }
  command address_t RouteState.getParent() {
    return parent;
  }
  command cost_t RouteState.getCost() {
    return cost;
  }
  command uint8_t RouteState.getHop() {
    return hop;
  }
  command void RouteState.getEstimate(address_t id, uint8_t *sendEstimate, uint8_t *receiveEstimate) {
    uint8_t indes = findEntry(id);
    if (indes == (uint8_t) ROUTE_INVALID) {
      *sendEstimate = 0;
      *receiveEstimate = 0;
    } else {
      *sendEstimate = routeTable[indes].sendEst;
      *receiveEstimate = routeTable[indes].receiveEst;
    }
  }
  command void RouteHelp.fillDropHeader(TOS_MsgPtr msg) {
    msg->addr = TOS_BCAST_ADDR;
  }
  command void RouteHelp.fillHeader(TOS_MsgPtr msg, uint8_t isOriginated) {
    // this will prevent retransmission, make the chanell more congestion when everyone is invalid
    if (parent == (address_t) ROUTE_INVALID) {
      msg->addr = TOS_BCAST_ADDR;
    } else {
      msg->addr = parent;
    }
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * trying to detect if there is a cycle, this have to BE FAST!!!!
   * since we are not puting this into a task
   * @author: alec, terence
   * @param: void
   * @return: 1 if cycle, 0 if not
   */
  command uint8_t RouteHelp.isCycle() {
    address_t pParent;
    uint8_t pIsChild, indes;
    if (parent == (address_t) ROUTE_INVALID) return 0;
    indes = findEntry(parent);
    if (indes == (uint8_t) ROUTE_INVALID) return 0;
    pParent = routeTable[indes].parent;
    pIsChild = (routeTable[indes].childLiveliness != 0);
    
    if (pParent == TOS_LOCAL_ADDRESS || pIsChild == 1)
      return 1;
    return 0;
  }
  command void RouteHelp.clearChildren() {
    uint8_t i;
    for (i = 0; i < ROUTE_TABLE_SIZE; i++) {
      routeTable[i].childLiveliness = 0;
    }
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * so basically there is an incoming packet, fill in the child 
   * field of the table. it is so compilcated because we are going to
   * filled in the child field only if we can possibly hear it. That is
   * in our neighbhood table
   * @author: terence
   * @param: msg, the incoming message
   * @return: void
   */
  command void RouteHelp.updateChildEntry(TOS_MsgPtr msg) {
    uint8_t indes, *data = (uint8_t *) msg->data;
    address_t realSource, source;
    MHSenderHeader *mhsenderHeader;
    VirtualCommHeader *vch = (VirtualCommHeader *) &data[msg->length]; // since this is above VC
    // extract the real source and source
    mhsenderHeader = (MHSenderHeader *) 
      &msg->data[msg->length - sizeof(MHSenderHeader)];
    source = vch->source;
    realSource = (mhsenderHeader->realSource == TOS_LOCAL_ADDRESS) ?
      parent : mhsenderHeader->realSource;
    // find the index of the table
    indes = findEntry(realSource);
    // if there is such entry or it is a immediate source, dumb it in!
    if (indes != (uint8_t) ROUTE_INVALID) {
      routeTable[indes].childLiveliness = ROUTE_MAX_LIVELINESS; return;
    }
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * We are going to decrease liveliness, call our estimator to 
   * call our periodic update
   * @author: terence
   * @param: void
   * @return: void
   */
  command void RouteHelp.updateTable() {
    uint8_t i = 0;
    for(i = 0; i < ROUTE_TABLE_SIZE; i++) {
      if (routeTable[i].valid != 1) continue;
      if (routeTable[i].childLiveliness != 0){
	routeTable[i].childLiveliness--;
      }
      routeTable[i].receiveEst 
        = call Estimator.timerUpdate(routeTable[i].trackInfo, routeTable[i].id, estimatorTicks);
    }
    // to prevent overflow
    estimatorTicks = (estimatorTicks + 1) % (ESTIMATE_TO_ROUTE_RATIO * BASE_STATION_SCALE);
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * there is an incoming packet, we are going to ask our estimate 
   * to do an estimation
   * @author: terence
   * @param: msg, incoming message
   * @return: void
   */
  command void RouteHelp.estimateNode(TOS_MsgPtr msg) {
    uint8_t *data = (uint8_t *) msg->data, indes;
    address_t source;
    int8_t seqnum;
    VirtualCommHeader *vch = (VirtualCommHeader *) &data[msg->length];
    source = vch->source;
    seqnum = vch->seqnum;       
    indes = findPreparedIndex(source);
    
    routeTable[indes].receiveEst = call Estimator.estimate(routeTable[indes].trackInfo, seqnum);
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * This is going to sort the table by cost and we are going 
   * to filled the input array
   * @author: terence
   * @param: ids, the input array going to be filled in
   * @param: length, the maximum length of the array
   * @return: how many entry do we filled in. notice that it can be smaller
   * than the input lenght
   */
  command uint8_t RouteHelp.getNeighbors(address_t *ids, uint8_t length) {
    uint8_t i, counter = 0;
    for (i = 0; i < length; i++) {
      if(routeTable[i].valid == 1) {
        ids[counter] = routeTable[i].id;
        counter++;
      }
    }
    return counter;
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * someone call this function asking for information about
   * this node
   * @author: terence
   * @param: all the infomation pointer
   * @return: void
   */
  command void RouteHelp.getNeighborInfo(address_t id, address_t *parentInput, uint8_t *hopInput, 
                                         cost_t *costInput, uint8_t *sendEstInput, 
                                         uint8_t *receiveEstInput, bool *isDescendent) {
    uint8_t indes = findEntry(id);
    if (indes == (uint8_t) ROUTE_INVALID) {
      *parentInput = ROUTE_INVALID;
      *hopInput = ROUTE_INVALID;
      *costInput = 0;
      *sendEstInput = 0;
      *receiveEstInput = 0;
      *isDescendent = FALSE;
    } else {
      *parentInput = routeTable[indes].parent;
      *hopInput = routeTable[indes].hop;
      *costInput = routeTable[indes].cost;
      *sendEstInput = routeTable[indes].sendEst;
      *receiveEstInput = routeTable[indes].receiveEst;
      *isDescendent = (routeTable[indes].childLiveliness > 0);
    }
  }
  // for internal sorting
  struct SimpleEntry {
    uint8_t valid;
    address_t id;
    uint8_t receiveEst;
    uint8_t sendEst;
    cost_t cost;
  };
  /*//////////////////////////////////////////////////////// */
  
  /*
   * Well, sort by the receive estimate, used by qsort for the get top receive function
   * @author: terence
   * @param: x, y two point of entries
   * @return: 1 means to the y should be the left, -1 means x should be on the left
   */
  int sortByReceiveEstFcn(const void *x, const void *y) {
    struct SimpleEntry *nx = (struct SimpleEntry *) x;
    struct SimpleEntry *ny = (struct SimpleEntry *) y;
    uint8_t xReceiveEst = nx->receiveEst, yReceiveEst = ny->receiveEst;
    if (nx->valid == 0 && ny->valid == 1) return 1;
    if (nx->valid == 0 && ny->valid == 0) return 0;
    if (nx->valid == 1 && ny->valid == 0) return -1;
    if (nx->valid == 1 && ny->valid == 1) {
      if (xReceiveEst > yReceiveEst) return -1;
      if (xReceiveEst == yReceiveEst) return 0;
      if (xReceiveEst < yReceiveEst) return 1;
    }
    return 0; // shouldn't reach here becasue it covers all the cases
  }
  /*//////////////////////////////////////////////////////// */
  /*
   * send a packet out, filled in the route packet with the current info
   * parent hop cost estlength (node id + receiveEst)*
   * and then send it out to virtual comm
   * @author: terence
   * @param: void
   * @return: void
   */
  command void RouteHelp.sendRoute() {
    uint8_t *data = (uint8_t *) routeMsg.data;
    uint8_t i;
    struct RoutePacket *rp = (struct RoutePacket *) data;
    uint8_t maxSize = (TOSH_DATA_LENGTH - sizeof(VirtualCommHeader) - sizeof(struct RoutePacket)) 
      / sizeof(struct RoutePacketFeedBack);
    uint8_t length, maxEstLength = 0, estLength = 0;
    struct SimpleEntry simpleEntry[ROUTE_TABLE_SIZE];
    struct RoutePacketFeedBack *feedbacks = (struct RoutePacketFeedBack *) &data[sizeof(struct RoutePacket)];
    // if we are sending before, why send it out
    if (routeSending == 1) 
      { return; }
    // fill in the first portion of the packet
    rp->parent = parent;
    rp->hop = hop;
    rp->cost = cost;
    data = &data[sizeof(struct RoutePacket)];
    length = sizeof(struct RoutePacket);
    // we are sending it out in the order of receive estimate
    
    for (i = 0; i < ROUTE_TABLE_SIZE; i++) {
      simpleEntry[i].valid = routeTable[i].valid;
      simpleEntry[i].id = routeTable[i].id;
      simpleEntry[i].receiveEst = routeTable[i].receiveEst;
      simpleEntry[i].sendEst = routeTable[i].sendEst;
      simpleEntry[i].cost = routeTable[i].cost;
    }
    qsort(simpleEntry, ROUTE_TABLE_SIZE, sizeof(struct SimpleEntry), sortByReceiveEstFcn);
    // find out how much source + estimation pair we can fill
    maxEstLength = (maxSize > ROUTE_TABLE_SIZE) ? ROUTE_TABLE_SIZE : maxSize;
    for (i = 0; i < maxEstLength; i ++) {
      // is this valid
      if (simpleEntry[i].valid == 1) {
        // fill in the source, estimation pair
        feedbacks->id = simpleEntry[i].id;
        feedbacks->receiveEst = simpleEntry[i].receiveEst;
        feedbacks++;
        length += sizeof(struct RoutePacketFeedBack);
        estLength ++;
      } else {
        break;
      }
    }
    rp->estLength = estLength;
    
    // send it to virtual comm
    // if it fail, doesn't count, if success, set route sending to true
    routeSending = call VCSend.send(TOS_BCAST_ADDR, length, &routeMsg);
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * turn off the sending flag when senddone come back
   */
  event result_t VCSend.sendDone(TOS_MsgPtr msg, result_t delivered) {
    routeSending = 0;
    return SUCCESS;
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * extract the packet and put it back to the table, after all this
   * signal to routing component about the packet coming
   * @author: terence
   * @param: msg, the receive packet
   * @return: pointer give back to the lower level comm layer
   */
  event TOS_MsgPtr RouteReceive.receive(TOS_MsgPtr msg) {
    // save down the packet
    uint8_t i, *data = (uint8_t *) msg->data, seqnum, indes;
    address_t source;
    VirtualCommHeader *vch = (VirtualCommHeader *) &data[msg->length];
    struct RoutePacketFeedBack *feedbacks = (struct RoutePacketFeedBack *) &data[sizeof(struct RoutePacket)];
    struct RoutePacket *rp = (struct RoutePacket *) data; 
    // extract the source seqnum
    source = vch->source;
    seqnum = vch->seqnum;
    
    indes = findPreparedIndex(source);
    // find a entry (prossibly kicking someone out)
    routeTable[indes].parent = rp->parent;
    routeTable[indes].hop = rp->hop;
    routeTable[indes].cost = rp->cost;
    // find out my address, extract the estimation
    data = &msg->data[sizeof(struct RoutePacket)];
    for (i = 0; i < rp->estLength; i ++) {
      if (feedbacks->id == TOS_LOCAL_ADDRESS) {
        routeTable[indes].sendEst = feedbacks->receiveEst;
        break;
      }
      feedbacks++;
    }
    // signal up the receive route event
    signal ReceiveRouteMsg.receive(msg);
    return msg;
  }
        
    
  /*////////////////////////////////////////////////////////*/
  /**
   * this message is sniffed on the air, we make use of this opportunity for
   * out estimation calculation
   * @author: terence, alec
   * @param: msg, message that is on the air, including to those not destinated to local address
   * @return: msg to give back to radio stack
   */
  event TOS_MsgPtr ReceiveAll.receive(TOS_MsgPtr msg) {
    call RouteHelp.estimateNode(msg);
    return msg;
  }
  default event TOS_MsgPtr ReceiveRouteMsg.receive(TOS_MsgPtr msg){
    return msg;
  }
}
