/* -*- Mode: C; c-basic-indent: 2; indent-tabs-mode: nil -*- */ 
/* $Id: RoutingStack.h,v 1.13 2003/06/22 01:08:45 ttong Exp $ */
/*////////////////////////////////////////////////////////*/
/**
 * 
 * Author: Terence Tong, Alec Woo
 */
/*////////////////////////////////////////////////////////*/
typedef uint8_t address_t;


typedef struct MHSenderHeader {
  uint8_t dataSeqnum;
  address_t realSource;
} MHSenderHeader;

// MHSender Parameters
enum {
  MHSENDER_DATA_QUEUE_SIZE = 20,
  MHSENDER_FORWARD_QUEUE_SIZE = 20,
  MHSENDER_RETRANSMIT_TRIAL = 3,
  MHSENDER_PACKET_HISTORY_SIZE = 5
};

// Handler Types
enum {
  MH_COLLECT_DATA_TYPE = 1,
  MH_STATISTIC_TYPE = 102,

  RS_DATA_TYPE = 1,
  RS_ROUTE_TYPE = 2,
  RS_DB_TYPE = 3,
  RS_COMMAND_TYPE = 5,
  RS_ESTIMATOR_DEBUG = 12,
  RS_TABLE_PACKET_TYPE = 6,
};




typedef uint16_t cost_t;
// Routing Protocol Related
enum {
  BASE_STATION = 1,
  ROUTE_TABLE_SIZE = 30,
  ROUTE_INVALID = -1,
  ROUTE_MAX_LIVELINESS = 50,
  ROUTE_MSG_RETRANSMIT = 0,
  ROUTE_FREQ = 6000
};

// Estimator Related
enum {
  ESTIMATE_TO_ROUTE_RATIO = 15,
  TRACK_INFO_SIZE = 8,
  ACCEPTABLE_MISSED = -20,
  HISTORY_WEIGHT = 2,
  BASE_STATION_SCALE = 2
};


enum {
  VC_MINIMUM_RESEND_TIME = 125,      // Predefined minimum retransmission time
  VC_QUEUESIZE = 11,                 // Default queue size
  VC_BITMAP_SIZE = 256,              // BITMASK 256 to support all AM types
  SIGNAL_RETRAN = -1
};


typedef struct VirtualCommHeader {
  address_t source;    // add source on the packet
  int8_t seqnum;      // add link sequence number
} VirtualCommHeader;




enum {
  MHSENDER_HEADER_OFFSET = (sizeof(VirtualCommHeader)),
  TOTAL_HEADER_LENGTH = (MHSENDER_HEADER_OFFSET + sizeof(MHSenderHeader))
};




// nesc 1.1
/*
  #define DECLARE_LOCK ;
  #define ACQUIRE_LOCK atomic {
  #define RELEASE_LOCK }
*/
// nesc 1.0

#define DECLARE_LOCK uint8_t interruptFlag;
#define ACQUIRE_LOCK interruptFlag = TOSH_interrupt_disable();
#define RELEASE_LOCK if (interruptFlag == 1) { TOSH_interrupt_enable(); }
