
// AUTOGENERATED! DO NOT MODIFIED !!!!

/* -*- Mode: C; c-basic-indent: 2; indent-tabs-mode: nil -*- */ 
/* $Id: SimpleWmewmaM.nc,v 1.8 2003/06/21 07:29:40 ttong Exp $ */
/*////////////////////////////////////////////////////////*/
/**
 * Author: Alec Woo, Terence Tong
 * An Estimator calculate reliablit based on how many packet we get, missed, and do 
 * packets collect / (missed + packet collect), We do this within a certain window
 * and we also do a moving average with it
 */
/*////////////////////////////////////////////////////////*/
includes RoutingStack;
module SimpleWmewmaM {
  provides {
    interface Estimator;
  }
   
}
implementation {
  typedef struct TrackInfo_t { 
    uint16_t missed;
    uint16_t received;
    int8_t lastSeqnum;
    uint8_t goodness;
    uint8_t new;
  } TrackInfo_t;
  enum {
    BRAND_NEW = 2,
    TOO_NEW = 1,
    READY = 0
  };
  TOS_Msg sendMsg;
  uint8_t sending;
  
  uint8_t historyWeight = HISTORY_WEIGHT;
  /*////////////////////////////////////////////////////////*/
  /**
   * This is just going to save down in the struct to indicated that
   * this is new
   * @author: alec, terence
   * @param: rawTrackInfo, it is just an array, you should mark it as new
   * @return: void
   */
  
  command void Estimator.clearTrackInfo(uint8_t *rawTrackInfo) {
    TrackInfo_t *trackInfo = (TrackInfo_t *) rawTrackInfo;
    trackInfo->new = BRAND_NEW;
    trackInfo->goodness = 0;
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * The main algorithm. that is packet received / total packets
   * @author: alec, terence
   * @param: rawTrackInfo, the estimator stuct
   * @param: seqnum, the incoming packet link sequence number
   * @return: the estimation
   */
  
  command uint8_t Estimator.estimate(uint8_t *rawTrackInfo, int8_t seqnum) {
    TrackInfo_t *trackInfo = (TrackInfo_t *) rawTrackInfo;
    int8_t missed = 0;
    // Receive a new packet
    missed = (seqnum - trackInfo->lastSeqnum - 1);
    if (trackInfo->new == BRAND_NEW) {
      trackInfo->goodness = 0;
      trackInfo->missed = 0;
      trackInfo->received++;
      trackInfo->lastSeqnum = seqnum;
      trackInfo->new = TOO_NEW;
    } else if (missed < ACCEPTABLE_MISSED) {
      trackInfo->lastSeqnum = seqnum;
      trackInfo->new = TOO_NEW;
      
    } else if (missed < 0) {
      // out of order, duplicate packet, ignore it ...
    } else if (missed >= 0) {
      // if it is positive
      trackInfo->missed += missed;
      trackInfo->received++;
      trackInfo->lastSeqnum = seqnum;
    }
    return trackInfo->goodness;
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * This is going to timeout the window, so flushed all the state to goodness
   * and reset all other state
   * @author: alec, terence
   * @param: rawTrackInfo, it is the array
   * @param: source, this is the source of the packet, we need this because basestation only
   * send route packet, so we need to make a case for that
   * @param: timerTick, number of ticks
   * @return: void
   */
  command uint8_t Estimator.timerUpdate(uint8_t *rawTrackInfo, address_t source, uint8_t timerTicks) {
    TrackInfo_t *trackInfo = (TrackInfo_t *) rawTrackInfo;
    uint16_t total, expTotal;
    uint16_t newAve;
    int16_t numRoutePacketExpected = ESTIMATE_TO_ROUTE_RATIO;
    uint16_t tmp;
    
    // We only perform estimation every ESTIMATE_ROUTE_RATIO * timer events
    if (source == BASE_STATION) {
      if (timerTicks % (ESTIMATE_TO_ROUTE_RATIO * BASE_STATION_SCALE) != 0) { return trackInfo->goodness; }
    } else {
      if (timerTicks % ESTIMATE_TO_ROUTE_RATIO != 0) { return trackInfo->goodness; }
    }
    // if it is Brand new!, return
    // BRAND NEW means we called an update, but we never call a estimate
    // TOO NEW means, we called an estimate
    if (trackInfo->new == BRAND_NEW ) {
      return trackInfo->goodness;
    } else if (trackInfo->new == TOO_NEW) {
      trackInfo->new = READY;
    } 
    if (source == BASE_STATION) {
      expTotal = numRoutePacketExpected * BASE_STATION_SCALE;
    } else {
      expTotal = numRoutePacketExpected;
    }
    // Compute the expected total packets that must have received
    total = trackInfo->received + trackInfo->missed;
    if (total < expTotal) {
      total = expTotal;
    }
    newAve = ((uint16_t) 255 * (uint16_t) trackInfo->received) / (uint16_t)total;
    
    if (trackInfo->new == TOO_NEW) {
      trackInfo->goodness = (uint8_t) newAve;
    } else {
      // Compute EWMA
      tmp = (uint16_t) historyWeight * (uint16_t) trackInfo->goodness;
      tmp += (uint16_t) (8 - historyWeight) * (uint16_t) newAve;
      tmp = tmp / 8; 
      trackInfo->goodness = (uint8_t) tmp;
    }
    // reset my history
    trackInfo->missed = 0;
    trackInfo->received = 0;
    
    return trackInfo->goodness;
  }
}
