
// AUTOGENERATED! DO NOT MODIFIED !!!!

/* -*- Mode: C; c-basic-indent: 2; indent-tabs-mode: nil -*- */ 
/* $Id: MHSenderM.nc,v 1.18 2003/06/21 06:44:52 ttong Exp $ */
/*									tab:4
 * "Copyright (c) 2000-2002 The Regents of the University  of California.  
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 */
/*									tab:4
 *  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.  By
 *  downloading, copying, installing or using the software you agree to
 *  this license.  If you do not agree to this license, do not download,
 *  install, copy or use the software.
 *
 *  Intel Open Source License 
 *
 *  Copyright (c) 2002 Intel Corporation 
 *  All rights reserved. 
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are
 *  met:
 * 
 *	Redistributions of source code must retain the above copyright
 *  notice, this list of conditions and the following disclaimer.
 *	Redistributions in binary form must reproduce the above copyright
 *  notice, this list of conditions and the following disclaimer in the
 *  documentation and/or other materials provided with the distribution.
 *      Neither the name of the Intel Corporation nor the names of its
 *  contributors may be used to endorse or promote products derived from
 *  this software without specific prior written permission.
 *  
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 *  PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE INTEL OR ITS
 *  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 *  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 *  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*////////////////////////////////////////////////////////*/
/**
 * MHSender queues up forwarding and originated packets. It modifies
 * those packets (by adding some header) and send to VirtualComm
 * It has an ability to do flow control on forwarding packets and 
 * originated packets. 
 * Duplicate packets are detected here and dropped. This is also 
 * where the routing stack provides intercept interfaces to applications.
 * Author: Terence Tong, Alec Woo
 */
/*////////////////////////////////////////////////////////*/
module MHSenderM {
  provides {
    interface Send as MultiHopSend[uint8_t msgId];
    interface StdControl;
    interface Intercept[uint8_t msgId];
    interface MHTraffic;
  }
  uses {
    interface ReceiveMsg as ForwardReceive;
    interface SendMsg as MHSend2Comm[uint8_t msgId];
    interface StdControl as CommControl;
    interface Retransmit as Retransmit[uint8_t msgId];
    interface RetransmitSignal[uint8_t msgId];
    interface Random;
  }
}
implementation {
  uint8_t sending;  // Sending flag
  TOS_MsgPtr msgToSend;  // Pointer to the msg pending to be sent
  // queue for storing originating multihop data packets
  uint8_t pendingOriginatedData[FIFOQUEUE_SIZE(MHSENDER_DATA_QUEUE_SIZE)];
  QueuePtr pendingOriginated;
  // queue for storing forwarding multihop packets
  uint8_t forwardQueueData[FIFOQUEUE_SIZE(MHSENDER_FORWARD_QUEUE_SIZE)];
  QueuePtr forwardQueue;
  // free list buffer for the comm layer, so it would not recycle the wrong stuff
  TOS_Msg freeListSpace[MHSENDER_FORWARD_QUEUE_SIZE];
  uint8_t freeListData[FIFOQUEUE_SIZE(MHSENDER_FORWARD_QUEUE_SIZE)];
  QueuePtr freeList;
  int8_t dataSeqnum;  // Data sequence number.  We need this to avoid duplicated packet.
  // Internal structure to elimiate duplicated packets.
  // This saves space as it avoids storing the dataSeqnum in neighborhood table
  typedef struct PacketHistory {
    address_t realSource;   // stores the source of the packet?  
    uint8_t dataSeqnum;  // stores the data sequence number of the packet
  } PacketHistory;
  // Allocate memory for PacketHistory
  PacketHistory packetHistory[MHSENDER_PACKET_HISTORY_SIZE];
  uint8_t packetHistoryIndex;
  // The default is to have the probability to set to 100% of data
  uint8_t routeStackStatus = 0;
  enum {
    DECISION_DATA = 0,       // Constant: send the data packet
    DECISION_FORWARD = 1,    // Constant: send the forwarding packet
    DECISION_NOTSENDING = 2  // Constant: send nothing
  };
  /*////////////////////////////////////////////////////////*/
  /**
   * keep track of packet history to avoid duplicated packets.
   * @author: terence, alec
   * @param: msg we want to record down so we can distinguish duplicated
   * packet later
   * @return: void
   */
  // the length here is without virtual comm header
  void recordPacketToHistory(TOS_MsgPtr msg) {
    MHSenderHeader *mhsenderHeader = (MHSenderHeader *) &msg->data[msg->length - sizeof(MHSenderHeader)];
    packetHistory[packetHistoryIndex].realSource = mhsenderHeader->realSource;
    packetHistory[packetHistoryIndex].dataSeqnum = mhsenderHeader->dataSeqnum;
    packetHistoryIndex = (packetHistoryIndex + 1) % MHSENDER_PACKET_HISTORY_SIZE;
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * Examine the packetHistory to decide whether the msg is duplicated or not
   * @author: terence
   * @param: msg, message to be test to see if this is duplicated 
   * @return: 1 if yes
   */
  // the length here is without virtual comm header
  uint8_t isDuplicatePacket(TOS_MsgPtr msg) {
    uint8_t i;
    MHSenderHeader *mhsenderHeader = (MHSenderHeader *) &msg->data[msg->length - sizeof(MHSenderHeader)];
    for (i = 0; i < MHSENDER_PACKET_HISTORY_SIZE; i++) {
      if (packetHistory[i].realSource == mhsenderHeader->realSource
          && packetHistory[i].dataSeqnum == mhsenderHeader->dataSeqnum) {
        return 1;
      }
    }
    return 0;
  }
  
  /*////////////////////////////////////////////////////////*/
  /**
   * Bandwidth control policy: Gives priority to originated messages first.
   * This helps detected cycles. It is reasonable because originated
   * packets are rare compared to forward packet.
   * @author: terence, alec
   * @param: decision, the result will be return here
   * @param: forwrad, 1 if there is forward message
   * @param: data, 1 if there is data message
   * @return: void
   */
  
  void makeDecisionData(uint8_t *decision, uint8_t forward, uint8_t data) {
    *decision = DECISION_NOTSENDING;
    if (forward == 1 && data == 0)
      *decision = DECISION_FORWARD;
    else if (forward == 0 && data == 1)
      *decision = DECISION_DATA;
    else if (forward == 1 && data == 1) {
        *decision = DECISION_DATA;
    }
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * Send packet down to comm according to our bandwidth control
   * policy
   * @author: terence, alec
   * @param: void
   * @return: void
   */
  // when put into the queue, the length of msg includes the mhsender heaer
  task void trySendMsg() {
    uint8_t decision, forward, data;
    result_t sendResult = SUCCESS;
    // if it is already sending, forget it!
    if (sending == 1) { return; }
    // detect if we have forward data and originated data
    forward = !queueIsEmpty(forwardQueue);
    data = !queueIsEmpty(pendingOriginated);
    // if we have none, forget it!
    if (forward == 0 && data == 0) { return; }
    // use the decision alternate algorithm
    makeDecisionData(&decision, forward, data);
    // decide to forward data
    if (decision == DECISION_FORWARD) {
      // get the first message and send (not dequeue yet)
      msgToSend = queueGetFirst(forwardQueue);
      // signal upper layer if they care about number of packets sent
      signal MHTraffic.notifySend(msgToSend);
      // the address (BASE_STATION) here doesn't mean anything
      sendResult = call MHSend2Comm.send[msgToSend->type](BASE_STATION, msgToSend->length, msgToSend);
      sending = sendResult;
      // decide to send originated data
    } else if (decision == DECISION_DATA) {
      msgToSend = queueGetFirst(pendingOriginated);
      // signal upper layer if they care about number of packets sent
      signal MHTraffic.notifySend(msgToSend);
      // copy pointer and send, the address (BASE_STATION) here doesn't mean anything
      sendResult = call MHSend2Comm.send[msgToSend->type](BASE_STATION, msgToSend->length, msgToSend);
      sending = sendResult;
      // if fail, let people overwrite the data, set send data comm as not busy
    } else {
      // happen only if there is nothing to send
      return;
    }
    // SHOULD NOT HAPPEN if VirtualComm is used.
    // Since sendResult == FAIL, msgToSend is not null
    if (sendResult == FAIL) { 
      signal MHSend2Comm.sendDone[msgToSend->type](msgToSend, 0); 
    } else {
    } 
  }
  command result_t StdControl.init() {
    call CommControl.init();
    return SUCCESS;
  }
  command result_t StdControl.start() {
    int i;
    if (routeStackStatus == 1)
      { return FAIL; }
    routeStackStatus = 1;
    
    sending = 0;
    call CommControl.start();
    // initialise the queues
    forwardQueue = 
      queueInit(forwardQueueData, FIFOQUEUE_SIZE(MHSENDER_FORWARD_QUEUE_SIZE));
    pendingOriginated = 
      queueInit(pendingOriginatedData, FIFOQUEUE_SIZE(MHSENDER_DATA_QUEUE_SIZE));
    freeList = 
      queueInit(freeListData, FIFOQUEUE_SIZE(MHSENDER_FORWARD_QUEUE_SIZE));
    // initialise the free list
    for (i = 0; i < MHSENDER_FORWARD_QUEUE_SIZE; i++) {
      queueEnqueue(freeList, &freeListSpace[i]);
    }
    for (i = 0; i < MHSENDER_PACKET_HISTORY_SIZE; i++) {
      packetHistory[i].realSource = 0xff;
      packetHistory[i].dataSeqnum = 0xff;
    }
    packetHistoryIndex = 0;
    return SUCCESS;
  }
  command result_t StdControl.stop() {
    routeStackStatus = 0;
    call CommControl.stop();
    return SUCCESS;
  }
  
  /*////////////////////////////////////////////////////////*/
  /**
   * Implements the getBuffer interface as defined in the multihop routing interface
   * @author: terence, alec
   * @param: msg, the message application want to send
   * @param: length, allowed length will be returned here
   * @return: void
   */
  command void* MultiHopSend.getBuffer[uint8_t msgId](TOS_MsgPtr msg, uint16_t* length) {
    *length = TOSH_DATA_LENGTH - TOTAL_HEADER_LENGTH;
    return msg->data;
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * This interface queues up the originating multihop message
   * @author: terence, alec
   * @param: msg, message mulihop application want to send
   * @param: length, the data payload (excluding any header)
   * @return: was it success. fail when length is too long, or there are too
   * many multihop application using mhsender.
   */
  command result_t MultiHopSend.send[uint8_t msgId](TOS_MsgPtr msg, uint16_t length) {
    MHSenderHeader *mh = (MHSenderHeader *) &msg->data[length]; 
    uint8_t error = 0;
    DECLARE_LOCK;
    ACQUIRE_LOCK;
    if (queueIsFull(pendingOriginated) == 1) { error = 1; }
    // do not let application send more
    error |= length > (TOSH_DATA_LENGTH - TOTAL_HEADER_LENGTH);
    if (error == 0) {
      msg->type = msgId;
      // put in the right length
      msg->length = length + sizeof(MHSenderHeader);
      mh->dataSeqnum = dataSeqnum++;
      mh->realSource = TOS_LOCAL_ADDRESS;
      queueEnqueue(pendingOriginated, msg);
    }
    RELEASE_LOCK;
    if (error == 1) {
      return FAIL;
    } else {
      post trySendMsg();
      return SUCCESS;
    }
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * signal up multihop application whether this packet should be forward
   * it is also when multihop applicaiton have a chance to do some proccessing
   * @author: terence, alec
   * @param: msg, the receive forward message
   * @return: the forward decision mulihop application gave.
   */
  result_t intercept(TOS_MsgPtr msg) {
    uint8_t *payload;
    uint16_t payloadLen;
    payload = msg->data;
    //payloadLen = msg->length - TOTAL_HEADER_LENGTH; 
    payloadLen = msg->length - sizeof(MHSenderHeader);
    // tell the applicatioin that there is a forwarding packet
    return signal Intercept.intercept[msg->type](msg, payload, payloadLen);
  }
  default event result_t Intercept.intercept[uint8_t mhsenderType](TOS_MsgPtr msg, void* payload, uint16_t payloadLen) {
    // if no one care, of course keep going!
    return SUCCESS;
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * We receive a packet from our children, We adjust the header
   * of the message and deposit it to our forwarading queue
   * @author: terence, alec
   * @param: msg, received message
   * @return: packet give back to the comm to recycle
   */
  event TOS_MsgPtr ForwardReceive.receive(TOS_MsgPtr msg) {
    TOS_MsgPtr recycleMsg = msg;
    uint8_t bufferOverflow, duplicate;
    uint8_t error = 0;
    DECLARE_LOCK;
    ACQUIRE_LOCK;
    // if queue overflow, discard! let comm recycle incoming msg
    bufferOverflow = (queueIsFull(forwardQueue) == 1) 
      || (queueIsEmpty(freeList) == 1);
    duplicate = isDuplicatePacket(msg);
    error = bufferOverflow || duplicate;
    error |= (intercept(msg) == FAIL);
    if (error == 0) {
      // cache the copy
      recordPacketToHistory(msg);
      // adjust the length before we put into queue
      // put it into the forward queue
      queueEnqueue(forwardQueue, msg);
      // give a ptr for the underlying to recycle
      recycleMsg = queueDequeue(freeList);
      
    }
    RELEASE_LOCK;
    if (error == 0) {
      post trySendMsg();
      return recycleMsg;
    } else {
      return msg;
    }
  }
  task void sendOriginatedDone() {
    TOS_MsgPtr originatedMsg;
    originatedMsg = queueDequeue(pendingOriginated);    
    sending = 0;
    signal MultiHopSend.sendDone[originatedMsg->type](originatedMsg, originatedMsg->ack);
  }
  task void sendForwardDone() {
    TOS_MsgPtr forwardMsg;
    forwardMsg = queueDequeue(forwardQueue);
    // if forward packet, we recycle the packet
    queueEnqueue(freeList, forwardMsg);
    sending = 0;
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * A send done event signaled by the comm. We checked to see
   * if this is a data message or a forward message. We post a task
   * to do the dequque operation
   * @author: terence, alec
   * @param: msg, pointer coming back from virtual comm. WARNING! This can 
   * be non multihop message. Do not assume it is and put it to our queue
   * @return: SUCCESS 
   */
  event result_t MHSend2Comm.sendDone[uint8_t typeid](TOS_MsgPtr msg, uint8_t delivered) {
    uint8_t type;
    TOS_MsgPtr originatedMsg, forwardMsg;
    MHSenderHeader *mhsenderHeader;
    VirtualCommHeader *vch;
    uint8_t dataQueueEmpty;
    uint8_t forwardQueueEmpty;
    uint8_t error = 0;
    DECLARE_LOCK;
    mhsenderHeader = (MHSenderHeader *) &msg->data[msg->length - sizeof(MHSenderHeader)];
    // WARNING, this may be a problem when we add int routing header
    vch = (VirtualCommHeader *) &msg->data[msg->length]; 
    type = msg->type;
    // put the result in the ack field, so we can retrieve later
    msg->ack = delivered;
    ACQUIRE_LOCK;
    // we need to check if it is empty before we do get first, otherwise sig fault
    dataQueueEmpty = queueIsEmpty(pendingOriginated);
    forwardQueueEmpty = queueIsEmpty(forwardQueue);
    // get the first packet of each queue
    originatedMsg = dataQueueEmpty ? 0 : queueGetFirst(pendingOriginated);
    forwardMsg = forwardQueueEmpty ? 0 : queueGetFirst(forwardQueue);
    // get the right messaage and compare pointer
    if (msg != originatedMsg && msg != forwardMsg) 
      { error = 1; }
    if (error == 0 && msg == originatedMsg) {
      post sendOriginatedDone();
      post trySendMsg();
    } else if (error == 0 && msg == forwardMsg) {
      post sendForwardDone();
      post trySendMsg();
    } 
    RELEASE_LOCK;
    return SUCCESS;
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * for all message we retransmit 
   * @author: terence, alec
   * @param: msg, message we just sent
   * @return: number of retransmission
   */
  event uint8_t Retransmit.getRetransmitDecision[uint8_t msgId](TOS_MsgPtr msg) {
    return MHSENDER_RETRANSMIT_TRIAL;
  }
  event result_t RetransmitSignal.retransmitSignal[uint8_t msgId](TOS_MsgPtr msg) {
    if (msg == msgToSend){
      signal MHTraffic.notifySendDoneFail(msg, 1);
    }
    return SUCCESS;
  }
  default event result_t MultiHopSend.sendDone[uint8_t msgId](TOS_MsgPtr msg, result_t success) {
    return SUCCESS;
  }
  default event void MHTraffic.notifySend(TOS_MsgPtr msg) {
    
  }
  default event void MHTraffic.notifySendDone(TOS_MsgPtr msg, bool delivered) {
  }
  default event void MHTraffic.notifySendDoneFail(TOS_MsgPtr msg, uint8_t retransmit) {
  }
}
