
// AUTOGENERATED! DO NOT MODIFIED !!!!

/* -*- Mode: C; c-basic-indent: 2; indent-tabs-mode: nil -*- */ 
/* $Id: VirtualCommM.nc,v 1.19 2003/06/21 06:43:45 ttong Exp $ */
/*									tab:4
 *
 *
 * "Copyright (c) 2000-2002 The Regents of the University  of California.  
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 */
/*									tab:4
 *  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.  By
 *  downloading, copying, installing or using the software you agree to
 *  this license.  If you do not agree to this license, do not download,
 *  install, copy or use the software.
 *
 *  Intel Open Source License 
 *
 *  Copyright (c) 2002 Intel Corporation 
 *  All rights reserved. 
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are
 *  met:
 * 
 *	Redistributions of source code must retain the above copyright
 *  notice, this list of conditions and the following disclaimer.
 *	Redistributions in binary form must reproduce the above copyright
 *  notice, this list of conditions and the following disclaimer in the
 *  documentation and/or other materials provided with the distribution.
 *      Neither the name of the Intel Corporation nor the names of its
 *  contributors may be used to endorse or promote products derived from
 *  this software without specific prior written permission.
 *  
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 *  PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE INTEL OR ITS
 *  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 *  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 *  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * 
 */
/*////////////////////////////////////////////////////////*/
/**
 * Applications do not need to worry about the comm is currently
 * sending or receiving. This component is called "VirtualComm" because
 * application can treat the comm as if it is the only one using the comm.
 * Every application is gaureeteed a chance to send regardless of 
 * what other applications are sending.
 * VirtualComm also provides a retranmission mechanism for the applications.
 * Author: Terence Tong, Alec Woo
 */
/*////////////////////////////////////////////////////////*/
module VirtualCommM {
  provides {
    interface SendMsg as InComing[uint8_t typeid];
    interface ReceiveMsg[uint8_t typeid];
    interface StdControl;
    interface Retransmit[uint8_t msgId];
    interface RetransmitSignal[uint8_t msgId];
    interface ReceiveMsg as SnoopTraffic;
  }
  uses {
    interface SendMsg as OutGoing[uint8_t typeid];
    interface Random;
    interface CommControl;
    interface Timer as ResendTimer;
    interface StdControl as CommStdControl;
    interface ReceiveMsg as ReceiveAllMsg[uint8_t typeid];
  }
}
implementation {
  // Declare virtual-comm busy bitmap array
  uint8_t busyBitmapData[BITARRAY_SIZE(VC_BITMAP_SIZE)];  // could store 256 busy entry
  BitArrayPtr busyBitMap;                                 // pointer to the busyBit buffer
  // Declare a fifo queue for storing the packet
  uint8_t pendingQueueData[FIFOQUEUE_SIZE(VC_QUEUESIZE)]; // queue 
  QueuePtr pendingQueue;                                  // pointer to the queue
  int8_t  linkSeqnum;   // link seqnum of this node
  uint8_t sending;      // sending flag to show packet is still sending
  uint8_t timerSet;     // this flag shows the retransmission timer is running
  int8_t numRetrans;   // keep track the number of retransmission
  command bool StdControl.init() {
    // Initialize the pointers
    busyBitMap = bitArrayInit(busyBitmapData, BITARRAY_SIZE(VC_BITMAP_SIZE));
    pendingQueue = queueInit(pendingQueueData, FIFOQUEUE_SIZE(VC_QUEUESIZE));
    call Random.init();
    call CommStdControl.init();
    // Initialize frame variables
    sending = 0;
    timerSet = 0;
    linkSeqnum = 1;
    
    return SUCCESS;
  }
  command bool StdControl.start() {
    call CommStdControl.start();
    call CommControl.setPromiscuous(TRUE);
    call CommControl.setCRCCheck(TRUE);
    return SUCCESS;
  }
  command bool StdControl.stop() {
    call CommStdControl.stop();
    return SUCCESS;
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * Schedule the restransmission timer to fire
   * if someone schedule a timer before, leave it alone. There is 
   * at most one timer schedule to resent at any moment
   * WARNING This need to be in SYNCHONOUS REGION
   * @author: terence, alec
   * @param: void
   * @return: void
   */
  void startTimer() {
    uint16_t randomizedTime;
    uint8_t result;
    // check if there is any messages. if there is none, do nothing, just return
    if (queueIsEmpty(pendingQueue) == 1) { return; }
    if (timerSet == 1) { return; } // don't set the timer if it is already set
    // Set the timer flag
    timerSet = 1;
    // give me some random time, schedule timer
    // randomizedTime should be more than zero, otherwise timer won't fire
    randomizedTime = VC_MINIMUM_RESEND_TIME;
    randomizedTime += (call Random.rand() & 0xff);
    result = call ResendTimer.start(TIMER_ONE_SHOT, randomizedTime);
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * This is called to actually send the packet, do automatic retranmit
   * if send return fail
   * @author: terence, alec
   * @param: void 
   * @return: void
   */
  // the length here is the whole thing!
  task void sendPacket() {
    uint8_t typeid;
    result_t sendResult;
    TOS_MsgPtr msgToSend;
    struct VirtualCommHeader *header;
    // nothing to send, return
    if (queueIsEmpty(pendingQueue) == 1) { return; }
    // if i am not sending anything right now, send it!
    // if timer is sent, which means we should not try to send anything, because comm is busy
    if (sending == 1 || timerSet == 1) { return; }
    // getfirst of the queue
    msgToSend = (TOS_MsgPtr) queueGetFirst(pendingQueue);
    
    // extract the addr, length, typeid from the msg
    typeid = msgToSend->type;
    // fill in the link seqnum
    header = (struct VirtualCommHeader *) &msgToSend->data[msgToSend->length - sizeof(struct VirtualCommHeader)]; 
    header->source = TOS_LOCAL_ADDRESS;
    header->seqnum = linkSeqnum;
    // send message!
    sendResult = call OutGoing.send[typeid](msgToSend->addr, msgToSend->length, msgToSend);
    // if send return success, keep the msg there
    // if fail start a timer, do automatic resend
    if (sendResult == FAIL){
      startTimer();
      sending = 0;
    } else {
      sending = 1;
    }
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * Reset the timer and attempt to send packet as a task.
   * @author: terence, alec
   * @param: void
   * @return: void
   */
  event result_t ResendTimer.fired() {
    uint8_t result;
    DECLARE_LOCK;
    ACQUIRE_LOCK;
    timerSet = 0;
    result = post sendPacket();
    
    RELEASE_LOCK;
    return SUCCESS;
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * A message is passed to Virtual comm, it will then be deposited
   * to our internal queue, waiting to be sent
   * @author: alec, terence
   * @param: 
   * @return: success, if deposited, fail if length too big, or queue is full
   * or there already exist a message with the same am type
   */
  command result_t InComing.send[uint8_t typeid](uint16_t address, uint8_t length, TOS_MsgPtr msg) {
    struct VirtualCommHeader *header = (struct VirtualCommHeader *) &msg->data[length]; 
    uint8_t result;
    uint8_t errorResult;
    DECLARE_LOCK;
    // if length too big, return false
    if (length + sizeof(VirtualCommHeader) > TOSH_DATA_LENGTH) 
      { FATAL("Size Too Big!"); return FAIL; }
    
    ACQUIRE_LOCK;
    // if there exist a message that has a same typid as incoming message
    result = bitArrayReadBit(typeid, busyBitMap) == 1;
    // check if the queue is full, if so, return false
    result |= queueIsFull(pendingQueue) == 1;
    
    if (result == 0) {
      errorResult = bitArrayWriteBit(typeid, 1, busyBitMap);
      
      // put in all the stuff to the message
      msg->addr = address;
      msg->length = sizeof(struct VirtualCommHeader) + length;
      msg->type = typeid;
      header->source = TOS_LOCAL_ADDRESS;
      // then put it in our queue
      errorResult = queueEnqueue(pendingQueue, msg); 
    }
    RELEASE_LOCK;
    if (result == 1) 
      { FATAL("VirtualComm, VirtualComm Busy"); return FAIL; }
    errorResult = post sendPacket();
    
    
    return SUCCESS;
  }
  
  /*////////////////////////////////////////////////////////*/
  /**
   * Receiving a sendDone triggers this task to either retransmit the current packet
   * or drop the current packet and send the next packet in the queue. 
   * @author: alec, terence
   * @param: void
   * @return: void
   */
  task void sendDoneTask() {
    TOS_MsgPtr msg = queueGetFirst(pendingQueue);
    uint8_t typeid = msg->type;
    uint8_t errorResult;
    void *errorVoidPtr;
    //uint8_t retransmit = 0;
    if (msg->ack == 0 && numRetrans == SIGNAL_RETRAN) {
      // Let upper layer to decide how many retransmissions for this packet
      numRetrans = signal Retransmit.getRetransmitDecision[typeid](msg);
    } else if (msg->ack == 1) {
      numRetrans = 0;
    }
    
    if (numRetrans == 0) {
      // busy flag to raise
      errorResult = bitArrayWriteBit(typeid, 0, busyBitMap);
      
      // remove the message from the queue, move on to the next one
      errorVoidPtr = queueDequeue(pendingQueue);
      
      // set sending flag to 0, so next one can send
      sending = 0;
      // reset the retransmission counter
      numRetrans = SIGNAL_RETRAN;
      // subtract the length of virtual comm header
      msg->length = msg->length - sizeof(VirtualCommHeader);
      // signal up the application about the result
      signal InComing.sendDone[typeid](msg, msg->ack == 1);
      // send next one
      errorResult = post sendPacket();
    } else if (numRetrans > 0){
      // we set the timerSet here and start timer
      startTimer();
      // doesn't matter because timerSet is set
      sending = 0;
      // keep track of number of retransmission
      numRetrans--;
      // Hook this up for statistical purposes
      signal RetransmitSignal.retransmitSignal[typeid](msg);
    }  
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * Send done come back from GenericComm Signal Up!
   * @author: terence, alec
   * @param: msg, the sent msg pointer
   * @param: success, the result of the sent
   * @return: always SUCCESS
   */
  // remove the item in the queue if necessary
  event result_t OutGoing.sendDone[uint8_t typeid](TOS_MsgPtr msg, result_t success) {
    uint8_t error, sendResult;
    uint8_t errorResult;
    DECLARE_LOCK;
    if (success == SUCCESS && msg->addr != TOS_UART_ADDR) {
      // increment seqnum only if send success and not to uart
      linkSeqnum++;
    }
    ACQUIRE_LOCK;
    // if queue is empty or the message is not mine, discard
    error = (queueIsEmpty(pendingQueue) == 1) || (queueGetFirst(pendingQueue) != msg);
    if (error == 0) {
      // sae the send result
      sendResult = (success == SUCCESS && msg->ack == TRUE);
      msg->ack = sendResult;
      errorResult = post sendDoneTask();
      
    }
    
    RELEASE_LOCK;
    return SUCCESS;
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * We sniff all packets in the air, including packet not directed
   * to this mote, We then dispatch it here, providing upper applications
   * a choice of receiving of snooping and plain receiving.
   * @author: terence, alec
   * @param: msg, the message coming from the air
   * @return: original message
   */
  event TOS_MsgPtr ReceiveAllMsg.receive[uint8_t typeid](TOS_MsgPtr msg){
    TOS_MsgPtr returnMsg = msg;
    msg->length = msg->length - (sizeof(VirtualCommHeader));
    // Signal to SnoopTraffic:  for snoop
    // Assume all traffic has VC header
    signal SnoopTraffic.receive(msg);
    // Signal to ReceiveMsg destined to this node
    if (msg->addr == TOS_LOCAL_ADDRESS || msg->addr == TOS_BCAST_ADDR){
      returnMsg = signal ReceiveMsg.receive[typeid](msg);
    }
    return returnMsg;
  }
  default event result_t InComing.sendDone[uint8_t typeid](TOS_MsgPtr msg, uint8_t result) {
    return SUCCESS;
  }
  /*////////////////////////////////////////////////////////*/
  /**
   * The number we return here is number of retransmissino application
   * wants. If the application don't provide this method. We, by default,
   * do not retransmit
   * @author: terence, alec
   * @param: msg, the message to retransmit
   * @return: 0, no retransmision
   */
  default event uint8_t Retransmit.getRetransmitDecision[uint8_t typeid](TOS_MsgPtr msg) {
    return 0;
  }
  default event result_t RetransmitSignal.retransmitSignal[uint8_t typeid](TOS_MsgPtr msg) {
    return SUCCESS;
  }
  default event TOS_MsgPtr SnoopTraffic.receive(TOS_MsgPtr msg){
    return msg;
  }
  default event TOS_MsgPtr ReceiveMsg.receive[uint8_t typeid](TOS_MsgPtr msg){
    return msg;
  }
}
