/* -*- Mode: C; c-basic-indent: 2; indent-tabs-mode: nil -*- */ 
/* $Id: CollectDataM.nc,v 1.3 2003/06/22 23:05:15 ttong Exp $ */
/*////////////////////////////////////////////////////////*/
/**
 * This application emulate surge packet, so we can use the surge gui to display
 * the multihop network
 * author: Terence Tong, Alec Woo
 */
/*////////////////////////////////////////////////////////*/

includes RoutingStack;

module BlastGUIM {
  provides {
    interface StdControl;
  }
  uses {
    interface Send as MultiHopSend;
    interface Timer as Timer;
    interface Leds;
    interface RouteState;
  }
}

#define DATA_FREQ 1000
implementation {


typedef struct BlastGUIInternalMsg {
  uint8_t type;
  uint16_t sourceaddr;
  uint16_t originaddr;
  uint16_t parentaddr;
  uint8_t seqno;
  uint8_t hopcount;
  uint16_t reading;
  uint8_t parent_link_quality;
  uint8_t padding;
} BlastGUIInternalMsg;


  TOS_Msg msgToSend;

  uint8_t counter;
  uint8_t sending;

  command result_t StdControl.init() {
    return SUCCESS;
  }
  command result_t StdControl.start() {
    int i;
    counter = 0;
    for (i = 0; i < 29; i++) {
      msgToSend.data[i] = 0;
    }
    call Timer.start(TIMER_REPEAT, DATA_FREQ);
    return SUCCESS;
  }
  command result_t StdControl.stop() {
    return SUCCESS;
  }

  /*////////////////////////////////////////////////////////*/
  /**
   * When the clock fired we are ready to send, collectdata ask the stack 
   * where in the data payload we can safely put our data. We then call 
   * Multihop passed the pointer down the stack
   * @author: terence
   * @param: void  
   * @return: always return success
   */
  event result_t Timer.fired() {
    // struct DataFormat_t *dataPortion;
    uint8_t *dataPortion;
    uint16_t availableLength = 0;
    uint8_t parentSendEst = 0, parentReceiveEst = 0;
    struct BlastGUIInternalMsg *sm;
    if (sending == 1) return SUCCESS;
    dataPortion = call MultiHopSend.getBuffer(&msgToSend, &availableLength);
    sm = (struct BlastGUIInternalMsg *) dataPortion;
    sm->type = 0;
    sm->sourceaddr = TOS_LOCAL_ADDRESS;
    sm->originaddr = TOS_LOCAL_ADDRESS; // we will use intercept to take care of this
    sm->parentaddr = call RouteState.getParent();
    sm->seqno = counter;
    counter++;
    sm->hopcount = call RouteState.getHop();
    sm->reading = 0;
    call RouteState.getEstimate(sm->parentaddr, &parentSendEst, &parentReceiveEst);
    sm->parent_link_quality = 100; // parentSendEst;
    sending = call MultiHopSend.send(&msgToSend, sizeof(struct BlastGUIInternalMsg));
    
    call Leds.redToggle();
    return SUCCESS;

  }

  /*////////////////////////////////////////////////////////*/
  /**
   * When a message is sent, send done event is trigger. We then schedule the
   * time to generate another message to send
   * @author: terence
   * @param: void 
   * @return: void
   */

  event result_t MultiHopSend.sendDone(TOS_MsgPtr msg, uint8_t success) {
    sending = 0;
    return SUCCESS;
  }
}
