/* -*- Mode: C; c-basic-indent: 2; indent-tabs-mode: nil -*- */ 
/* $Id: TestOneM.nc,v 1.2 2003/05/07 04:26:26 ttong Exp $ */
/*////////////////////////////////////////////////////////*/
/**
 * 
 * Author: Terence Tong
 */
/*////////////////////////////////////////////////////////*/


module TestOneM {
  provides {
    interface StdControl;
  }
  uses {
    interface SendMsg;
    interface Timer;
    interface Random;
    interface Leds;
    interface StdControl as CommStdControl;
  }
}

implementation {


#define DATA_FREQ 3000
  TOS_Msg msgToSend;

  command result_t StdControl.init() {
    call CommStdControl.init();
    call Leds.init();
    return SUCCESS;
  }
  command result_t StdControl.start() {    
    call Timer.start(TIMER_REPEAT, DATA_FREQ);
    call CommStdControl.start();
    return SUCCESS;
  }
  command result_t StdControl.stop() {
    call CommStdControl.stop();
    return SUCCESS;
  }
  uint8_t counter;
  /*////////////////////////////////////////////////////////*/
  /**
   * When the clock fired we are ready to send, 
   * @author: terence
   * @param: void  
   * @return: always return success
   */
  event result_t Timer.fired() {
    uint8_t result;
    msgToSend.data[0] = counter;
    counter++;

    result = call SendMsg.send(TOS_BCAST_ADDR, 1, &msgToSend);
    if (result == FAIL) 
      call Leds.yellowOn();
    else 
      call Leds.redToggle();


    return SUCCESS;
	
  }

  event uint8_t SendMsg.sendDone(TOS_MsgPtr msg, uint8_t success) {
    return 0;
  }

}
